/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.bundles.webjars;

import com.google.common.cache.CacheLoader;
import com.google.common.io.Closer;
import com.google.common.io.Resources;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

class VersionLoader
extends CacheLoader<String, String> {
    public static final String NOT_FOUND = "VERSION-NOT-FOUND";
    private final Iterable<String> groups;

    VersionLoader(Iterable<String> groups) {
        this.groups = groups;
    }

    public String load(String library) throws Exception {
        for (String group : this.groups) {
            String found = this.tryToLoadFrom("META-INF/maven/%s/%s/pom.properties", group, library);
            if (found == null) continue;
            return found;
        }
        return NOT_FOUND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tryToLoadFrom(String format, String group, String library) {
        String string;
        URL url;
        String path = String.format(format, group, library);
        try {
            url = Resources.getResource((String)path);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        Closer closer = Closer.create();
        InputStream in = (InputStream)closer.register((Closeable)url.openStream());
        try {
            Properties props = new Properties();
            props.load(in);
            string = props.getProperty("version");
        }
        catch (Throwable throwable) {
            try {
                closer.close();
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        closer.close();
        return string;
    }
}

