/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.bundles.webjars;

import com.google.common.base.Charsets;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import com.google.common.net.MediaType;
import io.dropwizard.bundles.webjars.Asset;
import io.dropwizard.bundles.webjars.AssetId;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.eclipse.jetty.http.MimeTypes;

class AssetLoader
extends CacheLoader<AssetId, Asset> {
    public static final Asset NOT_FOUND = new Asset(null, null);
    private static final MimeTypes MIME_TYPES = new MimeTypes();
    private static final MediaType DEFAULT_MEDIA_TYPE = MediaType.HTML_UTF_8;
    private static final Charset DEFAULT_CHARSET = Charsets.UTF_8;
    private final LoadingCache<String, String> versionCache;

    AssetLoader(CacheLoader<String, String> versionLoader) {
        this.versionCache = CacheBuilder.newBuilder().maximumSize(10L).build(versionLoader);
    }

    public Asset load(AssetId id) throws Exception {
        String version = (String)this.versionCache.getUnchecked((Object)id.library);
        if ("VERSION-NOT-FOUND".equals(version)) {
            return NOT_FOUND;
        }
        while (true) {
            String pathPattern = "META-INF/resources/webjars/%s/%s/%s";
            String path = String.format("META-INF/resources/webjars/%s/%s/%s", id.library, version, id.resource);
            try {
                URL resource = Resources.getResource((String)path);
                MediaType mediaType = this.getMediaType(path);
                this.versionCache.put((Object)id.library, (Object)version);
                return new Asset(ByteStreams.toByteArray((InputStream)resource.openStream()), mediaType);
            }
            catch (IllegalArgumentException resource) {
                int hyphen = version.lastIndexOf(45);
                if (hyphen == -1) {
                    return NOT_FOUND;
                }
                version = version.substring(0, hyphen);
                continue;
            }
            break;
        }
    }

    private MediaType getMediaType(String path) {
        MediaType mediaType;
        String mimeType = MIME_TYPES.getMimeByExtension(path);
        if (mimeType == null) {
            return DEFAULT_MEDIA_TYPE;
        }
        try {
            mediaType = MediaType.parse((String)mimeType);
            if (mediaType.is(MediaType.ANY_TEXT_TYPE)) {
                mediaType = mediaType.withCharset(DEFAULT_CHARSET);
            }
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_MEDIA_TYPE;
        }
        return mediaType;
    }
}

