/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.bundles.webjars;

import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.dropwizard.bundles.webjars.Asset;
import io.dropwizard.bundles.webjars.AssetId;
import io.dropwizard.bundles.webjars.AssetLoader;
import io.dropwizard.bundles.webjars.AssetWeigher;
import io.dropwizard.bundles.webjars.VersionLoader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.EntityTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebJarServlet
extends HttpServlet {
    public static final String DEFAULT_URL_PREFIX = "/webjars/";
    public static final String[] DEFAULT_MAVEN_GROUPS = new String[]{"org.webjars"};
    private static final Splitter IF_NONE_MATCH_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final Logger LOG = LoggerFactory.getLogger(WebJarServlet.class);
    private final String urlPrefix;
    private final Pattern pathParser;
    private final transient LoadingCache<AssetId, Asset> cache;

    public WebJarServlet(CacheBuilder builder, Iterable<String> groups, String urlPrefix) {
        if (builder == null) {
            builder = CacheBuilder.newBuilder().maximumWeight(0x500000L).expireAfterAccess(5L, TimeUnit.MINUTES);
        }
        if (groups == null || Iterables.isEmpty(groups)) {
            groups = ImmutableList.copyOf((Object[])DEFAULT_MAVEN_GROUPS);
        }
        AssetLoader loader = new AssetLoader(new VersionLoader((Iterable<String>)groups));
        this.cache = builder.weigher((Weigher)new AssetWeigher()).build((CacheLoader)loader);
        this.urlPrefix = urlPrefix;
        this.pathParser = Pattern.compile(urlPrefix + "([^/]+)/(.+)");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.handle(req, resp);
        }
        catch (Exception e) {
            LOG.info("Error processing request: {}", (Object)req, (Object)e);
            resp.sendError(500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = WebJarServlet.getFullPath(req);
        Matcher match = this.pathParser.matcher(path);
        if (!match.matches()) {
            resp.sendError(404);
            return;
        }
        AssetId id = new AssetId(match.group(1), match.group(2));
        Asset asset = (Asset)this.cache.getUnchecked((Object)id);
        if (asset == AssetLoader.NOT_FOUND) {
            resp.sendError(404);
            return;
        }
        resp.setDateHeader("Last-Modified", asset.lastModifiedTime);
        resp.setHeader("ETag", WebJarServlet.hash2etag(asset.hash));
        String ifNoneMatch = req.getHeader("If-None-Match");
        if (ifNoneMatch != null) {
            for (String etag : IF_NONE_MATCH_SPLITTER.split((CharSequence)ifNoneMatch)) {
                if (!"*".equals(etag) && !asset.hash.equals(WebJarServlet.etag2hash(etag))) continue;
                resp.sendError(304);
                return;
            }
        }
        if (asset.lastModifiedTime <= req.getDateHeader("If-Modified-Since")) {
            resp.sendError(304);
            return;
        }
        resp.setContentType(asset.mediaType.toString());
        if (asset.mediaType.charset().isPresent()) {
            resp.setCharacterEncoding(((Charset)asset.mediaType.charset().get()).toString());
        }
        try (ServletOutputStream output = resp.getOutputStream();){
            output.write(asset.bytes);
        }
    }

    private static String getFullPath(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder(request.getServletPath());
        if (request.getPathInfo() != null) {
            sb.append(request.getPathInfo());
        }
        return sb.toString();
    }

    private static String hash2etag(String hash) {
        return new EntityTag(hash).toString();
    }

    private static String etag2hash(String etag) {
        String hash;
        try {
            hash = EntityTag.valueOf((String)etag).getValue();
        }
        catch (Exception e) {
            return null;
        }
        if (hash.endsWith("-gzip")) {
            hash = hash.substring(0, hash.length() - 5);
        }
        return hash;
    }
}

