/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.tools.openapi;

import io.dinject.tools.openapi.OpenApiExtension;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;

public class OpenApiPlugin
implements Plugin<Project> {
    private static final String META_OPENAPI_JSON = "meta/openapi.json";

    public void apply(Project project) {
        OpenApiExtension params = (OpenApiExtension)project.getExtensions().create("openapi", OpenApiExtension.class, new Object[0]);
        project.afterEvaluate(p -> {
            TaskContainer tasks = project.getTasks();
            Task test = tasks.getByName("test");
            test.doFirst((Action)new LocalTask(project, params));
        });
    }

    class LocalTask
    implements Action<Task> {
        private final OpenApiExtension params;
        private final Logger logger;
        private final Project project;

        LocalTask(Project project, OpenApiExtension params) {
            this.params = params;
            this.project = project;
            this.logger = project.getLogger();
        }

        public void execute(Task task) {
            JavaPluginConvention plugin = (JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSet mainSourceSet = (SourceSet)plugin.getSourceSets().getByName("main");
            File resourceDir = this.findResourceDir(mainSourceSet);
            if (resourceDir == null) {
                this.logger.warn("Unable to find src/main/resources directory");
                return;
            }
            File metaOpenApi = this.findMetaOpenApi(mainSourceSet);
            if (metaOpenApi == null) {
                this.logger.warn("Unable to find the generated openapi.json file");
                return;
            }
            File destFile = new File(resourceDir, this.params.destination);
            File destDir = destFile.getParentFile();
            if (!destDir.exists() && !destDir.mkdirs()) {
                this.logger.error("Failed to make resource directory " + destDir);
            } else {
                this.moveOpenApiFile(metaOpenApi, destFile);
            }
        }

        private void moveOpenApiFile(File metaOpenApi, File destFile) {
            try {
                Files.copy(metaOpenApi.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.logger.info("moved open api file to main/resources: " + this.params.destination);
                if (!metaOpenApi.delete()) {
                    this.logger.warn("unable to delete " + metaOpenApi);
                }
            }
            catch (IOException e) {
                this.logger.error("Error copying openapi file", (Throwable)e);
            }
        }

        private File findMetaOpenApi(SourceSet mainSourceSet) {
            FileCollection classesDirs = mainSourceSet.getOutput().getClassesDirs();
            Set dirs = classesDirs.getFiles();
            for (File dir : dirs) {
                File metaApi = new File(dir, OpenApiPlugin.META_OPENAPI_JSON);
                if (!metaApi.exists()) continue;
                return metaApi;
            }
            return null;
        }

        private File findResourceDir(SourceSet mainSourceSet) {
            Set resDirs = mainSourceSet.getResources().getSrcDirs();
            for (File dir : resDirs) {
                if (dir == null) continue;
                return dir;
            }
            return null;
        }
    }
}

