/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.webroutegen;

import io.dinject.webroutegen.Append;
import io.dinject.webroutegen.MethodParam;
import io.dinject.webroutegen.MethodReader;
import io.dinject.webroutegen.PathSegments;
import io.dinject.webroutegen.ProcessingContext;
import io.dinject.webroutegen.WebMethod;
import java.util.List;

class ControllerMethodWriter {
    private final MethodReader method;
    private final Append writer;
    private final WebMethod webMethod;
    private final ProcessingContext ctx;

    ControllerMethodWriter(MethodReader method, Append writer, ProcessingContext ctx) {
        this.method = method;
        this.writer = writer;
        this.webMethod = method.getWebMethod();
        this.ctx = ctx;
    }

    void writeRule() {
        String fullPath = this.method.getFullPath();
        String bodyType = this.method.getBodyType();
        if (bodyType != null) {
            this.writer.append("    rules.%s(\"%s\", Handler.create(%s.class, this::_%s));", new Object[]{this.webMethod.name().toLowerCase(), fullPath, bodyType, this.method.simpleName()}).eol();
        } else if (this.method.isFormBody()) {
            this.writer.append("    rules.%s(\"%s\", Handler.create(%s.class, this::_%s));", new Object[]{this.webMethod.name().toLowerCase(), fullPath, "FormParams", this.method.simpleName()}).eol();
        } else {
            this.writer.append("    rules.%s(\"%s\", this::_%s);", new Object[]{this.webMethod.name().toLowerCase(), fullPath, this.method.simpleName()}).eol();
        }
    }

    void writeHandler() {
        this.writer.append("  private void _%s(ServerRequest req, ServerResponse res", new Object[]{this.method.simpleName()});
        String bodyType = this.method.getBodyType();
        if (bodyType != null) {
            this.writer.append(", %s %s", new Object[]{bodyType, this.method.getBodyName()});
        } else if (this.method.isFormBody()) {
            this.writer.append(", %s %s", new Object[]{"FormParams", "formParams"});
        }
        this.writer.append(") {").eol();
        if (!this.method.isVoid()) {
            this.writeContextReturn();
        }
        PathSegments segments = this.method.getPathSegments();
        List matrixSegments = segments.matrixSegments();
        for (Object matrixSegment : matrixSegments) {
            matrixSegment.writeCreateSegment(this.writer, this.ctx.platform());
        }
        List params = this.method.getParams();
        for (MethodParam param : params) {
            param.writeCtxGet(this.writer, segments);
        }
        this.writer.append("    ");
        if (!this.method.isVoid()) {
            this.writer.append("res.send(");
        }
        if (this.method.includeValidate()) {
            for (MethodParam param : params) {
                param.writeValidate(this.writer);
            }
        }
        this.writer.append("controller.");
        this.writer.append(this.method.simpleName()).append("(");
        for (int i = 0; i < params.size(); ++i) {
            if (i > 0) {
                this.writer.append(", ");
            }
            ((MethodParam)params.get(i)).buildParamName(this.writer);
        }
        this.writer.append(")");
        if (!this.method.isVoid()) {
            this.writer.append(")");
        }
        this.writer.append(";").eol();
        this.writer.append("  }").eol().eol();
    }

    private void writeContextReturn() {
        String produces = this.method.getProduces();
        if (produces != null) {
            if ("application/json".equalsIgnoreCase(produces)) {
                this.writer.append("    res.writerContext().contentType(io.helidon.common.http.MediaType.APPLICATION_JSON);").eol();
            } else if ("text/html".equalsIgnoreCase(produces)) {
                this.writer.append("    res.writerContext().contentType(io.helidon.common.http.MediaType.TEXT_HTML);").eol();
            } else if ("text/plain".equalsIgnoreCase(produces)) {
                this.writer.append("    res.writerContext().contentType(io.helidon.common.http.MediaType.TEXT_PLAIN);").eol();
            } else {
                this.writer.append("res.writerContext().contentType(io.helidon.common.http.MediaType.parse(\"%s\"));", new Object[]{produces}).eol();
            }
        }
    }

    public void buildApiDocumentation() {
        this.method.buildApiDoc();
    }
}

