/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.webroutegen;

import io.dinject.webroutegen.Append;
import io.dinject.webroutegen.ControllerReader;
import io.dinject.webroutegen.ParamType;
import io.dinject.webroutegen.PlatformAdapter;
import java.util.List;

class HelidonPlatformAdapter
implements PlatformAdapter {
    static final String HELIDON_REQ = "io.helidon.webserver.ServerRequest";
    static final String HELIDON_RES = "io.helidon.webserver.ServerResponse";
    static final String HELIDON_FORMPARAMS = "io.helidon.common.http.FormParams";

    HelidonPlatformAdapter() {
    }

    public boolean isContextType(String rawType) {
        return HELIDON_REQ.equals(rawType) || HELIDON_RES.equals(rawType) || HELIDON_FORMPARAMS.equals(rawType);
    }

    public String platformVariable(String rawType) {
        if (HELIDON_REQ.equals(rawType)) {
            return "req";
        }
        if (HELIDON_RES.equals(rawType)) {
            return "res";
        }
        if (HELIDON_FORMPARAMS.equals(rawType)) {
            return "formParams";
        }
        return "unknownVariable for: " + rawType;
    }

    public boolean isBodyMethodParam() {
        return true;
    }

    public String bodyAsClass(String shortType) {
        return "body";
    }

    public String indent() {
        return "  ";
    }

    public void controllerRoles(List<String> roles, ControllerReader controller) {
        this.addRoleImports(roles, controller);
    }

    public void methodRoles(List<String> roles, ControllerReader controller) {
        this.addRoleImports(roles, controller);
    }

    private void addRoleImports(List<String> roles, ControllerReader controller) {
    }

    public void writeReadParameter(Append writer, ParamType paramType, String paramName) {
        switch (paramType) {
            case PATHPARAM: {
                writer.append("req.path().param(\"%s\")", new Object[]{paramName});
                break;
            }
            case QUERYPARAM: {
                writer.append("req.queryParams().first(\"%s\").orElse(null)", new Object[]{paramName});
                break;
            }
            case FORMPARAM: {
                writer.append("formParams.first(\"%s\").orElse(null)", new Object[]{paramName});
                break;
            }
            case HEADER: {
                writer.append("req.headers().value(\"%s\").orElse(null)", new Object[]{paramName});
                break;
            }
            case COOKIE: {
                writer.append("req.headers().cookies().first(\"%s\").orElse(null)", new Object[]{paramName});
                break;
            }
            default: {
                writer.append("null // TODO req.%s().param(\"%s\")", new Object[]{paramType.getType(), paramName});
            }
        }
    }

    public void writeReadParameter(Append writer, ParamType paramType, String paramName, String paramDefault) {
        switch (paramType) {
            case PATHPARAM: {
                writer.append("req.path().param(\"%s\")", new Object[]{paramName});
                break;
            }
            case QUERYPARAM: {
                writer.append("req.queryParams().first(\"%s\").orElse(\"%s\")", new Object[]{paramName, paramDefault});
                break;
            }
            case FORMPARAM: {
                writer.append("formParams.first(\"%s\").orElse(\"%s\")", new Object[]{paramName, paramDefault});
                break;
            }
            case HEADER: {
                writer.append("req.headers().value(\"%s\").orElse(\"%s\")", new Object[]{paramName, paramDefault});
                break;
            }
            case COOKIE: {
                writer.append("req.headers().cookies().first(\"%s\").orElse(\"%s\")", new Object[]{paramName, paramDefault});
                break;
            }
            default: {
                writer.append("null // TODO req.%s().param(\"%s\")", new Object[]{paramType.getType(), paramName});
            }
        }
    }
}

