/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.webroutegen;

import io.dinject.webroutegen.BaseControllerWriter;
import io.dinject.webroutegen.ControllerMethodWriter;
import io.dinject.webroutegen.ControllerReader;
import io.dinject.webroutegen.MethodReader;
import io.dinject.webroutegen.ProcessingContext;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

class ControllerWriter
extends BaseControllerWriter {
    private static final String AT_GENERATED = "@Generated(\"io.dinject.helidon-webgen\")";

    ControllerWriter(ControllerReader reader, ProcessingContext ctx) throws IOException {
        super(reader, ctx);
        reader.addImportType("io.helidon.common.http.FormParams");
        reader.addImportType("io.helidon.webserver.Handler");
        reader.addImportType("io.helidon.webserver.Routing");
        reader.addImportType("io.helidon.webserver.ServerRequest");
        reader.addImportType("io.helidon.webserver.ServerResponse");
        reader.addImportType("io.helidon.webserver.Service");
    }

    void write() {
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        this.writeAddRoutes();
        this.writeClassEnd();
    }

    private List<ControllerMethodWriter> getWriterMethods() {
        return this.reader.getMethods().stream().filter(MethodReader::isWebMethod).map(it -> new ControllerMethodWriter((MethodReader)it, this.writer)).collect(Collectors.toList());
    }

    private void writeAddRoutes() {
        List<ControllerMethodWriter> methods = this.getWriterMethods();
        this.writeRoutes(methods);
        for (ControllerMethodWriter methodWriter : methods) {
            this.writeHandlerMethod(methodWriter);
        }
    }

    private void writeRoutes(List<ControllerMethodWriter> methods) {
        this.writer.append("  @Override").eol();
        this.writer.append("  public void update(Routing.Rules rules) {").eol().eol();
        for (ControllerMethodWriter methodWriter : methods) {
            methodWriter.writeRule();
            if (this.reader.isDocHidden()) continue;
            methodWriter.buildApiDocumentation();
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeHandlerMethod(ControllerMethodWriter methodWriter) {
        methodWriter.writeHandler();
    }

    private void writeClassStart() {
        if (this.ctx.isGeneratedAvailable()) {
            this.writer.append(AT_GENERATED).eol();
        }
        this.writer.append("@Singleton").eol();
        this.writer.append("public class ").append(this.shortName).append("$route implements Service {").eol().eol();
        this.writer.append(" private final %s controller;", new Object[]{this.shortName}).eol();
        if (this.reader.isIncludeValidator()) {
            this.writer.append(" private final Validator validator;").eol();
        }
        this.writer.eol();
        this.writer.append(" public %s$route(%s controller", new Object[]{this.shortName, this.shortName});
        if (this.reader.isIncludeValidator()) {
            this.writer.append(", Validator validator");
        }
        this.writer.append(") {").eol();
        this.writer.append("   this.controller = controller;").eol();
        if (this.reader.isIncludeValidator()) {
            this.writer.append("   this.validator = validator;").eol();
        }
        this.writer.append(" }").eol().eol();
    }
}

