/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.controller;

import io.dinject.controller.InvalidPathArgumentException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;

public class PathTypeConversion {
    private static void checkNull(String value) {
        if (value == null) {
            throw new InvalidPathArgumentException("path element is null");
        }
    }

    public static int asInt(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static long asLong(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static double asDouble(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return Double.valueOf(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static float asFloat(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return Float.valueOf(value).floatValue();
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static boolean asBool(String value) {
        PathTypeConversion.checkNull(value);
        return Boolean.valueOf(value);
    }

    public static BigDecimal asDecimal(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return new BigDecimal(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static LocalDate asDate(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return LocalDate.parse(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static LocalTime asTime(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return LocalTime.parse(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static LocalDateTime asDateTime(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return LocalDateTime.parse(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static UUID asUUID(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return UUID.fromString(value);
        }
        catch (RuntimeException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static Integer asInteger(String value) {
        PathTypeConversion.checkNull(value);
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static Integer toInteger(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static Long toLong(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static Boolean toBoolean(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public static UUID toUUID(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return UUID.fromString(value);
        }
        catch (Exception e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static LocalDate toLocalDate(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return LocalDate.parse(value);
        }
        catch (Exception e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static LocalTime toTime(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return LocalTime.parse(value);
        }
        catch (Exception e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    public static LocalDateTime toDateTime(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return LocalDateTime.parse(value);
        }
        catch (Exception e) {
            throw new InvalidPathArgumentException(e);
        }
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

