/*
 * Decompiled with CFR 0.152.
 */
package io.dinject.controller;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;

public class PathTypeConversion {
    public static int asInt(String value) {
        return Integer.valueOf(value);
    }

    public static long asLong(String value) {
        return Long.valueOf(value);
    }

    public static double asDouble(String value) {
        return Double.valueOf(value);
    }

    public static float asFloat(String value) {
        return Float.valueOf(value).floatValue();
    }

    public static boolean asBool(String value) {
        return Boolean.valueOf(value);
    }

    public static BigDecimal asDecimal(String value) {
        return new BigDecimal(value);
    }

    public static LocalDate asDate(String value) {
        return LocalDate.parse(value);
    }

    public static LocalTime asTime(String value) {
        return LocalTime.parse(value);
    }

    public static LocalDateTime asDateTime(String value) {
        return LocalDateTime.parse(value);
    }

    public static UUID asUUID(String value) {
        return UUID.fromString(value);
    }

    public static Integer asInteger(String value) {
        return Integer.valueOf(value);
    }

    public static Integer toInteger(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public static Long toLong(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        return Long.valueOf(value);
    }

    public static Boolean toBoolean(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public static UUID toUUID(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        return UUID.fromString(value);
    }

    public static LocalDate toLocalDate(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        return LocalDate.parse(value);
    }

    public static LocalTime toTime(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        return LocalTime.parse(value);
    }

    public static LocalDateTime toDateTime(String value) {
        if (PathTypeConversion.isNullOrEmpty(value)) {
            return null;
        }
        return LocalDateTime.parse(value);
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

