/*
 * Decompiled with CFR 0.152.
 */
package io.digital.patterns.keycloak.impersonate;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.digital.patterns.keycloak.impersonate.KeycloakConfiguration;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.JwtDecoders;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class KeycloakImpersonateService {
    @Generated
    private static final Logger log = Logger.getLogger(KeycloakImpersonateService.class.getName());
    private final RestTemplate restTemplate = new RestTemplate();
    private final KeycloakConfiguration keycloakConfiguration;
    private final NimbusJwtDecoder jwtDecoder;
    private final CacheManager cacheManager;
    private JwtTimestampValidator jwtTimestampValidator;
    private static final String CACHE_NAME = UUID.randomUUID().toString() + "-token-cache";

    public KeycloakImpersonateService(KeycloakConfiguration keycloakConfiguration) {
        this.keycloakConfiguration = keycloakConfiguration;
        String issuerUrl = this.issuerUrl(keycloakConfiguration);
        this.jwtDecoder = (NimbusJwtDecoder)JwtDecoders.fromOidcIssuerLocation((String)issuerUrl);
        this.jwtTimestampValidator = new JwtTimestampValidator();
        this.jwtDecoder.setJwtValidator((OAuth2TokenValidator)this.jwtTimestampValidator);
        this.cacheManager = new ConcurrentMapCacheManager(new String[]{CACHE_NAME});
    }

    private String issuerUrl(KeycloakConfiguration keycloakConfiguration) {
        if (keycloakConfiguration.getTokenExchangeUrl() == null) {
            return String.format("%s/realms/%s", keycloakConfiguration.getAuthUrl(), keycloakConfiguration.getAuthRealm());
        }
        return keycloakConfiguration.getTokenExchangeUrl().substring(0, keycloakConfiguration.getTokenExchangeUrl().indexOf("/protocol/openid-connect/token"));
    }

    public String generateAccessToken(String user) {
        log.log(Level.FINE, "Initiating access token request");
        Assert.notNull((Object)user, (String)"User cannot be null");
        TokenResult tokenResult = (TokenResult)Objects.requireNonNull(this.cacheManager.getCache(CACHE_NAME)).get((Object)"accessToken", () -> this.getNewAccessToken(user));
        if (tokenResult == null) {
            throw new IllegalStateException("Access token is null");
        }
        boolean invalidToken = false;
        try {
            this.jwtDecoder.decode(tokenResult.accessToken);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Token invalid " + e.getMessage());
            invalidToken = true;
        }
        if (invalidToken) {
            log.log(Level.FINE, "Token has expired. Requesting a new token using refresh token");
            TokenResult updated = this.refreshToken(tokenResult);
            Objects.requireNonNull(this.cacheManager.getCache(CACHE_NAME)).put((Object)"accessToken", (Object)updated);
            log.log(Level.FINE, "Token refreshed and stored in cache for later use");
            return updated.accessToken;
        }
        return tokenResult.accessToken;
    }

    private TokenResult refreshToken(TokenResult tokenResult) {
        String refreshToken = tokenResult.refreshToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"refresh_token", (Object)refreshToken);
        map.add((Object)"grant_type", (Object)"refresh_token");
        map.add((Object)"client_id", (Object)this.keycloakConfiguration.getClientId());
        map.add((Object)"client_secret", (Object)this.keycloakConfiguration.getClientSecret());
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        TokenResult updated = (TokenResult)this.restTemplate.exchange(String.format("%s/realms/%s/protocol/openid-connect/token", this.keycloakConfiguration.getAuthUrl(), this.keycloakConfiguration.getAuthRealm()), HttpMethod.POST, entity, TokenResult.class, new Object[0]).getBody();
        if (updated == null) {
            throw new IllegalStateException("Updated token is null");
        }
        return updated;
    }

    private String tokenExchangeUrl() {
        if (this.keycloakConfiguration.getTokenExchangeUrl() != null && !this.keycloakConfiguration.getTokenExchangeUrl().equalsIgnoreCase("")) {
            return this.keycloakConfiguration.getTokenExchangeUrl();
        }
        return String.format("%s/realms/%s/protocol/openid-connect/token", this.keycloakConfiguration.getAuthUrl(), this.keycloakConfiguration.getAuthRealm());
    }

    private TokenResult getNewAccessToken(String user) {
        log.info("Getting new access token on initial start...");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"password");
        map.add((Object)"username", (Object)this.keycloakConfiguration.getUsername());
        map.add((Object)"password", (Object)this.keycloakConfiguration.getPassword());
        String clientId = this.keycloakConfiguration.getClientId();
        map.add((Object)"client_id", (Object)clientId);
        String clientSecret = this.keycloakConfiguration.getClientSecret();
        map.add((Object)"client_secret", (Object)clientSecret);
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        String authUrl = this.tokenExchangeUrl();
        TokenResult token = (TokenResult)this.restTemplate.exchange(authUrl, HttpMethod.POST, entity, TokenResult.class, new Object[0]).getBody();
        if (token == null) {
            throw new IllegalStateException(String.format("Unable to get token for user %s", user));
        }
        map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:token-exchange");
        map.add((Object)"client_id", (Object)clientId);
        map.add((Object)"client_secret", (Object)clientSecret);
        map.add((Object)"subject_token", (Object)token.getAccessToken());
        map.add((Object)"requested_subject", (Object)user);
        map.add((Object)"subject_token_type", (Object)"urn:ietf:params:oauth:token-type:access_token");
        entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        token = (TokenResult)this.restTemplate.exchange(authUrl, HttpMethod.POST, entity, TokenResult.class, new Object[0]).getBody();
        return Optional.ofNullable(token).orElseThrow(() -> new IllegalStateException(String.format("Unable to get token for user %s", user)));
    }

    JwtTimestampValidator jwtTimestampValidator() {
        return this.jwtTimestampValidator;
    }

    public static class TokenResult {
        @JsonProperty(value="access_token")
        private String accessToken;
        @JsonProperty(value="refresh_token")
        private String refreshToken;

        @Generated
        public TokenResult() {
        }

        @Generated
        public String getAccessToken() {
            return this.accessToken;
        }

        @Generated
        public String getRefreshToken() {
            return this.refreshToken;
        }

        @JsonProperty(value="access_token")
        @Generated
        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @JsonProperty(value="refresh_token")
        @Generated
        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenResult)) {
                return false;
            }
            TokenResult other = (TokenResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            String this$refreshToken = this.getRefreshToken();
            String other$refreshToken = other.getRefreshToken();
            return !(this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TokenResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            String $refreshToken = this.getRefreshToken();
            result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "KeycloakImpersonateService.TokenResult(accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ")";
        }
    }
}

