package io.digital.patterns.keycloak.impersonate;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Builder
@Getter
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class KeycloakConfiguration {

    private String authUrl;
    private String authRealm;
    private String clientId;
    private String clientSecret;
    private String username;
    private String password;
    private String tokenExchangeUrl;
}
