/*
 * Decompiled with CFR 0.152.
 */
package io.digitalpatterns.camunda.encryption;

import io.digitalpatterns.camunda.encryption.EncryptionException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

abstract class ProcessInstanceSpinVariable {
    PBEParameterSpec pbeParamSpec;
    SecretKey secretKey;

    ProcessInstanceSpinVariable() {
    }

    void initialiseKeys(String passPhrase, String salt) {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            char[] passPhraseChar = passPhrase.toCharArray();
            byte[] saltAsBytes = salt.getBytes();
            this.pbeParamSpec = new PBEParameterSpec(saltAsBytes, 20);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passPhraseChar);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWITHSHA256AND128BITAES-CBC-BC");
            this.secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }
}

