/*
 * Decompiled with CFR 0.152.
 */
package io.digitalpatterns.camunda.encryption;

import java.io.InputStream;
import java.util.Optional;
import lombok.Generated;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionEncryptionParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessDefinitionEncryptionParser.class);
    private RepositoryService repositoryService;

    public ProcessDefinitionEncryptionParser(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean shouldEncrypt(ProcessDefinition processDefinition, String encryptVariablesKey) {
        return this.isEncryptionEnabled(encryptVariablesKey, processDefinition);
    }

    public boolean shouldEncrypt(String processKey, String encryptVariablesKey) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().active().singleResult();
        return this.isEncryptionEnabled(encryptVariablesKey, processDefinition);
    }

    private boolean isEncryptionEnabled(String encryptVariablesKey, ProcessDefinition processDefinition) {
        if (processDefinition == null) {
            throw new IllegalStateException("Process definition cannot be null");
        }
        BpmnModelInstance model = Bpmn.readModelFromStream((InputStream)this.repositoryService.getProcessModel(processDefinition.getId()));
        Optional<CamundaProperty> hasEncryption = model.getModelElementsByType(CamundaProperty.class).stream().filter(prop -> prop.getCamundaName().equalsIgnoreCase(encryptVariablesKey) && prop.getCamundaValue().equalsIgnoreCase("true")).findFirst();
        return hasEncryption.isPresent();
    }
}

