package io.digitalpatterns.camunda.encryption;

import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.camunda.bpm.engine.impl.cfg.AbstractProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;

@Slf4j
@Getter
public class ProcessInstanceSpinVariableEncryptionPlugin extends AbstractProcessEnginePlugin {

    private ProcessInstanceSpinVariableEncryptor processInstanceSpinVariableEncryptor;
    private ProcessInstanceSpinVariableDecryptor processInstanceSpinVariableDecryptor;


    public ProcessInstanceSpinVariableEncryptionPlugin(ProcessInstanceSpinVariableEncryptor defaultProcessInstanceSpinVariableEncryptor,
                                                       ProcessInstanceSpinVariableDecryptor defaultProcessInstanceSpinVariableDecryptor) {
        this.processInstanceSpinVariableEncryptor = defaultProcessInstanceSpinVariableEncryptor;
        this.processInstanceSpinVariableDecryptor = defaultProcessInstanceSpinVariableDecryptor;
    }


    public ProcessInstanceSpinVariableEncryptionPlugin(String passPhrase, String salt) {
        this(new DefaultProcessInstanceSpinVariableEncryptor(passPhrase, salt),
                new DefaultProcessInstanceSpinVariableDecryptor(passPhrase, salt));
    }


    @Override
    public void postInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        registerFunctionMapper(processEngineConfiguration);
    }

    private void registerFunctionMapper(ProcessEngineConfigurationImpl processEngineConfiguration) {
        SpinEncryptionFunctionMapper.defaultProcessInstanceSpinVariableDecryptor = this.processInstanceSpinVariableDecryptor;
        SpinEncryptionFunctionMapper.defaultProcessInstanceSpinVariableEncryptor = this.processInstanceSpinVariableEncryptor;


        processEngineConfiguration.setScriptingEnvironment(new EncryptionScriptingEnvironment(
                processEngineConfiguration,
                this.processInstanceSpinVariableDecryptor,
                this.processInstanceSpinVariableEncryptor
        ));


        processEngineConfiguration.getExpressionManager()
                .addFunctionMapper(new SpinEncryptionFunctionMapper());
    }


}
