package io.digitalpatterns.camunda.encryption;

import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import java.security.Security;

import static io.digitalpatterns.camunda.encryption.EncryptionConstants.ALGORITHM_NAME;

abstract class ProcessInstanceSpinVariable {

    PBEParameterSpec pbeParamSpec;
    SecretKey secretKey;

    void initialiseKeys(String passPhrase, String salt) {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
        }
        try {
            char[] passPhraseChar = passPhrase.toCharArray();
            byte[] saltAsBytes = salt.getBytes();
            this.pbeParamSpec = new PBEParameterSpec(saltAsBytes, 20);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passPhraseChar);
            SecretKeyFactory secretKeyFactory =
                    SecretKeyFactory.getInstance(ALGORITHM_NAME);
            this.secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
        } catch (Exception e) {
            throw new EncryptionException(e);
        }
    }
}
