package io.digitalpatterns.camunda.encryption;

import lombok.extern.slf4j.Slf4j;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;
import org.camunda.spin.Spin;
import org.camunda.spin.plugin.variable.value.impl.JsonValueImpl;
import org.springframework.util.Assert;

import javax.crypto.Cipher;
import javax.crypto.SealedObject;

import java.util.Map;

import static io.digitalpatterns.camunda.encryption.EncryptionConstants.ALGORITHM_NAME;

@Slf4j
public class DefaultProcessInstanceSpinVariableDecryptor  extends ProcessInstanceSpinVariable
        implements ProcessInstanceSpinVariableDecryptor{

    public DefaultProcessInstanceSpinVariableDecryptor(String passPhrase, String salt) {
        Assert.notNull(passPhrase, "PassPhrase cannot be null");
        Assert.notNull(salt, "Salt cannot be null");
        initialiseKeys(passPhrase, salt);
    }

    /**
     * Uses decrypted mechanism
     *
     * @param sealedObject
     * @return decrypted Spin object
     */
    public Spin decrypt(SealedObject sealedObject) {
        if (sealedObject == null) {
            log.warn("Sealed object is null so returning null");
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_NAME);
            cipher.init(Cipher.DECRYPT_MODE, this.secretKey, this.pbeParamSpec);
            log.debug("Preparing to decrypt object");
            Object object = sealedObject.getObject(cipher);
            return Spin.JSON(object);
        } catch (Exception e) {
            throw new DecryptionException(e);
        }
    }


    public VariableMap decrypt(Map<String, Object> variableMap) {
        variableMap.keySet().forEach(key -> {
            if (variableMap.get(key) instanceof SealedObject) {
                SealedObject variable = (SealedObject) variableMap.get(key);
                variableMap.replace(key, new JsonValueImpl(decrypt(variable).toString()));
            }
        });
        return new VariableMapImpl(variableMap);
    }

}
