/*
 * Decompiled with CFR 0.152.
 */
package io.digitalpatterns.camunda.encryption;

import io.digitalpatterns.camunda.encryption.ProcessInstanceSpinVariableDecryptor;
import io.digitalpatterns.camunda.encryption.ProcessInstanceSpinVariableEncryptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SealedObject;
import lombok.Generated;
import org.camunda.bpm.engine.impl.javax.el.FunctionMapper;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.spin.Spin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpinEncryptionFunctionMapper
extends FunctionMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpinEncryptionFunctionMapper.class);
    static ProcessInstanceSpinVariableDecryptor processInstanceSpinVariableDecryptor;
    static ProcessInstanceSpinVariableEncryptor processInstanceSpinVariableEncryptor;
    private static Map<String, Method> encryptionFunctionMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureContextFunctionMapInitialized() {
        if (encryptionFunctionMap != null) return;
        Class<SpinEncryptionFunctionMapper> clazz = SpinEncryptionFunctionMapper.class;
        synchronized (SpinEncryptionFunctionMapper.class) {
            if (encryptionFunctionMap != null) return;
            encryptionFunctionMap = new HashMap<String, Method>();
            this.createMethodBindings();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void createMethodBindings() {
        Class<?> mapperClass = ((Object)((Object)this)).getClass();
        encryptionFunctionMap.put("encrypt", ReflectUtil.getMethod(mapperClass, (String)"encrypt", (Class[])new Class[]{Object.class}));
        encryptionFunctionMap.put("decrypt", ReflectUtil.getMethod(mapperClass, (String)"decrypt", (Class[])new Class[]{Object.class}));
    }

    public Method resolveFunction(String prefix, String localName) {
        this.ensureContextFunctionMapInitialized();
        return encryptionFunctionMap.get(localName);
    }

    public static SealedObject encrypt(Object object) {
        return processInstanceSpinVariableEncryptor.encrypt(object);
    }

    public static Spin decrypt(Object sealedObject) {
        return processInstanceSpinVariableDecryptor.decrypt((SealedObject)sealedObject);
    }

    static {
        encryptionFunctionMap = null;
    }
}

