/*
 * Decompiled with CFR 0.152.
 */
package io.digitalpatterns.camunda.encryption;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.digitalpatterns.camunda.encryption.EncryptionException;
import io.digitalpatterns.camunda.encryption.ProcessInstanceSpinVariable;
import java.io.Serializable;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import lombok.Generated;
import org.camunda.spin.Spin;
import org.camunda.spin.impl.json.jackson.format.JacksonJsonDataFormat;
import org.camunda.spin.spi.DataFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceSpinVariableEncryptor
extends ProcessInstanceSpinVariable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceSpinVariableEncryptor.class);
    private JacksonJsonDataFormat formatter;

    public ProcessInstanceSpinVariableEncryptor(JacksonJsonDataFormat formatter, String passPhrase, String salt) {
        this.formatter = formatter;
        if (passPhrase == null) {
            throw new IllegalArgumentException("PassPhrase cannot be null");
        }
        if (salt == null) {
            throw new IllegalArgumentException("Salt cannot be null");
        }
        this.initialiseKeys(passPhrase, salt);
    }

    public ProcessInstanceSpinVariableEncryptor(String passPhrase, String salt) {
        this(new JacksonJsonDataFormat("application/json", new ObjectMapper()), passPhrase, salt);
    }

    public SealedObject encrypt(Object object) {
        Spin spinObject = Spin.S((Object)object, (DataFormat)this.formatter);
        return this.performSeal((Serializable)((Object)spinObject.toString()));
    }

    private SealedObject performSeal(Serializable object) {
        try {
            Cipher cipher = Cipher.getInstance("PBEWITHSHA256AND128BITAES-CBC-BC");
            cipher.init(1, (Key)this.secretKey, this.pbeParamSpec);
            return new SealedObject(object, cipher);
        }
        catch (Exception e) {
            log.error("Failed to create sealed object", (Throwable)e);
            throw new EncryptionException(e);
        }
    }
}

