/*
 * Decompiled with CFR 0.152.
 */
package io.digitalpatterns.camunda.encryption;

import io.digitalpatterns.camunda.encryption.DecryptionException;
import io.digitalpatterns.camunda.encryption.ProcessInstanceSpinVariable;
import java.security.Key;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import lombok.Generated;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;
import org.camunda.spin.Spin;
import org.camunda.spin.plugin.variable.value.impl.JsonValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ProcessInstanceSpinVariableDecryptor
extends ProcessInstanceSpinVariable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceSpinVariableDecryptor.class);

    public ProcessInstanceSpinVariableDecryptor(String passPhrase, String salt) {
        Assert.notNull((Object)passPhrase, (String)"PassPhrase cannot be null");
        Assert.notNull((Object)salt, (String)"Salt cannot be null");
        this.initialiseKeys(passPhrase, salt);
    }

    public Spin decrypt(SealedObject sealedObject) {
        try {
            Cipher cipher = Cipher.getInstance("PBEWITHSHA256AND128BITAES-CBC-BC");
            cipher.init(2, (Key)this.secretKey, this.pbeParamSpec);
            log.debug("Preparing to decrypt object");
            Object object = sealedObject.getObject(cipher);
            return Spin.JSON((Object)object);
        }
        catch (Exception e) {
            throw new DecryptionException(e);
        }
    }

    public VariableMap decrypt(Map<String, Object> variableMap) {
        variableMap.keySet().forEach(key -> {
            if (variableMap.get(key) instanceof SealedObject) {
                SealedObject variable = (SealedObject)variableMap.get(key);
                variableMap.replace((String)key, new JsonValueImpl(this.decrypt(variable).toString()));
            }
        });
        return new VariableMapImpl(variableMap);
    }
}

