package io.digitalpatterns.camunda.encryption;

import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.camunda.bpm.engine.impl.cfg.AbstractProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;

@Slf4j
@Getter
public class ProcessInstanceSpinVariableEncryptionPlugin extends AbstractProcessEnginePlugin {

    private ProcessInstanceSpinVariableEncryptor processInstanceSpinVariableEncryptor;
    private ProcessInstanceSpinVariableDecryptor processInstanceSpinVariableDecryptor;


    public ProcessInstanceSpinVariableEncryptionPlugin(ProcessInstanceSpinVariableEncryptor processInstanceSpinVariableEncryptor,
                                                       ProcessInstanceSpinVariableDecryptor processInstanceSpinVariableDecryptor) {
        this.processInstanceSpinVariableEncryptor = processInstanceSpinVariableEncryptor;
        this.processInstanceSpinVariableDecryptor = processInstanceSpinVariableDecryptor;
    }


    public ProcessInstanceSpinVariableEncryptionPlugin(String passPhrase, String salt) {
        this(new ProcessInstanceSpinVariableEncryptor(passPhrase, salt),
                new ProcessInstanceSpinVariableDecryptor(passPhrase, salt));
    }


    @Override
    public void postInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        registerFunctionMapper(processEngineConfiguration);
    }

    private void registerFunctionMapper(ProcessEngineConfigurationImpl processEngineConfiguration) {
        SpinEncryptionFunctionMapper.processInstanceSpinVariableDecryptor = this.processInstanceSpinVariableDecryptor;
        SpinEncryptionFunctionMapper.processInstanceSpinVariableEncryptor = this.processInstanceSpinVariableEncryptor;


        processEngineConfiguration.setScriptingEnvironment(new EncryptionScriptingEnvironment(
                processEngineConfiguration,
                this.processInstanceSpinVariableDecryptor,
                this.processInstanceSpinVariableEncryptor
        ));


        processEngineConfiguration.getExpressionManager()
                .addFunctionMapper(new SpinEncryptionFunctionMapper());
    }


}
