/*
 * Decompiled with CFR 0.152.
 */
package io.digitalpatterns.camunda.encryption;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.digitalpatterns.camunda.encryption.EncryptionException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import lombok.Generated;
import org.camunda.spin.Spin;
import org.camunda.spin.impl.json.jackson.format.JacksonJsonDataFormat;
import org.camunda.spin.spi.DataFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceSpinVariableEncryptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceSpinVariableEncryptor.class);
    private JacksonJsonDataFormat formatter;
    private PublicKey publicKey;

    public ProcessInstanceSpinVariableEncryptor(JacksonJsonDataFormat formatter, String pathToPublicKey) {
        this.formatter = formatter;
        if (pathToPublicKey == null) {
            throw new IllegalArgumentException("Path to public key cannot be null");
        }
        this.publicKey = this.loadPublicKey(pathToPublicKey);
    }

    public ProcessInstanceSpinVariableEncryptor(String pathToPublicKey) {
        this(new JacksonJsonDataFormat("application/json", new ObjectMapper()), pathToPublicKey);
    }

    public SealedObject encrypt(Object object) {
        Spin spinObject = Spin.S((Object)object, (DataFormat)this.formatter);
        return this.performSeal((Serializable)((Object)spinObject.toString()));
    }

    private SealedObject performSeal(Serializable object) {
        try {
            Cipher instance = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-512ANDMGF1PADDING");
            instance.init(1, this.publicKey);
            return new SealedObject(object, instance);
        }
        catch (Exception e) {
            log.error("Failed to create sealed object", (Throwable)e);
            throw new EncryptionException(e);
        }
    }

    private PublicKey loadPublicKey(String pathToPublicKey) {
        try {
            byte[] keyAsBytes = Files.readAllBytes(Paths.get(pathToPublicKey, new String[0]));
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyAsBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(spec);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }
}

