/*
 * Decompiled with CFR 0.152.
 */
package io.digitalpatterns.camunda.encryption;

import io.digitalpatterns.camunda.encryption.EncryptionScriptingEnvironment;
import io.digitalpatterns.camunda.encryption.ProcessInstanceSpinVariableDecryptor;
import io.digitalpatterns.camunda.encryption.ProcessInstanceSpinVariableEncryptor;
import io.digitalpatterns.camunda.encryption.SpinEncryptionFunctionMapper;
import lombok.Generated;
import org.camunda.bpm.engine.impl.cfg.AbstractProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.javax.el.FunctionMapper;
import org.camunda.bpm.engine.impl.scripting.env.ScriptingEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class ProcessInstanceSpinVariableEncryptionPlugin
extends AbstractProcessEnginePlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceSpinVariableEncryptionPlugin.class);
    private ProcessInstanceSpinVariableEncryptor processInstanceSpinVariableEncryptor;
    private ProcessInstanceSpinVariableDecryptor processInstanceSpinVariableDecryptor;

    public ProcessInstanceSpinVariableEncryptionPlugin(ProcessInstanceSpinVariableEncryptor processInstanceSpinVariableEncryptor, ProcessInstanceSpinVariableDecryptor processInstanceSpinVariableDecryptor) {
        this.processInstanceSpinVariableEncryptor = processInstanceSpinVariableEncryptor;
        this.processInstanceSpinVariableDecryptor = processInstanceSpinVariableDecryptor;
    }

    public ProcessInstanceSpinVariableEncryptionPlugin(ClassPathResource privateKeyResource, ClassPathResource publicKeyResource) throws Exception {
        this(privateKeyResource.getFile().getAbsolutePath(), publicKeyResource.getFile().getPath());
    }

    public ProcessInstanceSpinVariableEncryptionPlugin(String privateKeyPath, String publicKeyPath) {
        this(new ProcessInstanceSpinVariableEncryptor(publicKeyPath), new ProcessInstanceSpinVariableDecryptor(privateKeyPath));
    }

    public void postInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.registerFunctionMapper(processEngineConfiguration);
    }

    private void registerFunctionMapper(ProcessEngineConfigurationImpl processEngineConfiguration) {
        SpinEncryptionFunctionMapper.processInstanceSpinVariableDecryptor = this.processInstanceSpinVariableDecryptor;
        SpinEncryptionFunctionMapper.processInstanceSpinVariableEncryptor = this.processInstanceSpinVariableEncryptor;
        processEngineConfiguration.setScriptingEnvironment((ScriptingEnvironment)new EncryptionScriptingEnvironment(processEngineConfiguration, this.processInstanceSpinVariableDecryptor, this.processInstanceSpinVariableEncryptor));
        processEngineConfiguration.getExpressionManager().addFunctionMapper((FunctionMapper)new SpinEncryptionFunctionMapper());
    }

    @Generated
    public ProcessInstanceSpinVariableEncryptor getProcessInstanceSpinVariableEncryptor() {
        return this.processInstanceSpinVariableEncryptor;
    }

    @Generated
    public ProcessInstanceSpinVariableDecryptor getProcessInstanceSpinVariableDecryptor() {
        return this.processInstanceSpinVariableDecryptor;
    }
}

