/*
 * Decompiled with CFR 0.152.
 */
package io.digitalpatterns.camunda.encryption;

import io.digitalpatterns.camunda.encryption.DecryptionException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Map;
import javax.crypto.SealedObject;
import lombok.Generated;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;
import org.camunda.spin.Spin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceSpinVariableDecryptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceSpinVariableDecryptor.class);
    private PrivateKey privateKey;

    public ProcessInstanceSpinVariableDecryptor(String pathToPrivateKey) {
        if (pathToPrivateKey == null) {
            throw new IllegalArgumentException("Path to private key cannot be null");
        }
        this.privateKey = this.loadPrivateKey(pathToPrivateKey);
    }

    public Spin decrypt(SealedObject sealedObject) {
        try {
            log.info("Preparing to decrypt object");
            Object object = sealedObject.getObject(this.privateKey);
            return Spin.JSON((Object)object);
        }
        catch (Exception e) {
            throw new DecryptionException(e);
        }
    }

    public VariableMap decrypt(Map<String, Object> variableMap) {
        variableMap.keySet().forEach(key -> {
            if (variableMap.get(key) instanceof SealedObject) {
                SealedObject variable = (SealedObject)variableMap.get(key);
                variableMap.replace((String)key, this.decrypt(variable));
            }
        });
        return new VariableMapImpl(variableMap);
    }

    private PrivateKey loadPrivateKey(String pathToPrivateKey) {
        try {
            byte[] keyAsBytes = Files.readAllBytes(Paths.get(pathToPrivateKey, new String[0]));
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyAsBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(spec);
        }
        catch (Exception e) {
            throw new DecryptionException(e);
        }
    }
}

