/*
 * Decompiled with CFR 0.152.
 */
package io.digitalpatterns.camunda.encryption;

import io.digitalpatterns.camunda.encryption.ProcessInstanceSpinVariableDecryptor;
import io.digitalpatterns.camunda.encryption.ProcessInstanceSpinVariableEncryptor;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import lombok.Generated;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.env.ScriptingEnvironment;
import org.codehaus.groovy.runtime.MethodClosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EncryptionScriptingEnvironment
extends ScriptingEnvironment {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptionScriptingEnvironment.class);
    private static final Map<String, Map<String, Object>> TO_MERGE = new HashMap<String, Map<String, Object>>();
    private static final String JS_KEY = "javascript";
    private static final String GROOVY_KEY = "groovy";

    EncryptionScriptingEnvironment(ProcessEngineConfigurationImpl processEngineConfiguration, ProcessInstanceSpinVariableDecryptor processInstanceSpinVariableDecryptor, ProcessInstanceSpinVariableEncryptor processInstanceSpinVariableEncryptor) {
        super(processEngineConfiguration.getScriptFactory(), processEngineConfiguration.getEnvScriptResolvers(), processEngineConfiguration.getScriptingEngines());
        this.registerFunctions(processInstanceSpinVariableDecryptor, processInstanceSpinVariableEncryptor);
    }

    private void registerFunctions(ProcessInstanceSpinVariableDecryptor processInstanceSpinVariableDecryptor, ProcessInstanceSpinVariableEncryptor processInstanceSpinVariableEncryptor) {
        TO_MERGE.put(JS_KEY, Map.of("decrypt", processInstanceSpinVariableDecryptor::decrypt, "encrypt", processInstanceSpinVariableEncryptor::encrypt));
        TO_MERGE.put(GROOVY_KEY, Map.of("decrypt", new MethodClosure((Object)processInstanceSpinVariableDecryptor, "decrypt"), "encrypt", new MethodClosure((Object)processInstanceSpinVariableEncryptor, "encrypt")));
    }

    public Object execute(ExecutableScript script, VariableScope scope, Bindings bindings, ScriptEngine scriptEngine) {
        String language = scriptEngine.getFactory().getLanguageName().toLowerCase();
        HashMap<String, Object> bindingContext = new HashMap<String, Object>();
        switch (language) {
            case "groovy": {
                bindingContext.putAll(TO_MERGE.get(GROOVY_KEY));
                break;
            }
            case "javascript": 
            case "nashorn": 
            case "js": 
            case "ecmascript": {
                bindingContext.putAll(TO_MERGE.get(JS_KEY));
                break;
            }
            default: {
                log.info("Unknown scripting language '{}'", (Object)language);
            }
        }
        if (!CollectionUtils.isEmpty(bindingContext)) {
            bindings.putAll((Map<? extends String, ? extends Object>)bindingContext);
        }
        return super.execute(script, scope, bindings, scriptEngine);
    }
}

