package io.digitalpatterns.camunda.encryption;

import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.camunda.bpm.engine.impl.cfg.AbstractProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.springframework.core.io.ClassPathResource;

@Slf4j
@Getter
public class ProcessInstanceSpinVariableEncryptionPlugin extends AbstractProcessEnginePlugin {

    private ProcessInstanceSpinVariableEncryptor processInstanceSpinVariableEncryptor;
    private ProcessInstanceSpinVariableDecryptor processInstanceSpinVariableDecryptor;


    public ProcessInstanceSpinVariableEncryptionPlugin(ProcessInstanceSpinVariableEncryptor processInstanceSpinVariableEncryptor,
                                                       ProcessInstanceSpinVariableDecryptor processInstanceSpinVariableDecryptor) {
        this.processInstanceSpinVariableEncryptor = processInstanceSpinVariableEncryptor;
        this.processInstanceSpinVariableDecryptor = processInstanceSpinVariableDecryptor;
    }

    public ProcessInstanceSpinVariableEncryptionPlugin(ClassPathResource privateKeyResource,
                                                       ClassPathResource publicKeyResource) throws Exception {

        this(privateKeyResource.getFile().getAbsolutePath(), publicKeyResource.getFile().getPath());
    }

    public ProcessInstanceSpinVariableEncryptionPlugin(String privateKeyPath, String publicKeyPath) {
        this(new ProcessInstanceSpinVariableEncryptor(publicKeyPath), new ProcessInstanceSpinVariableDecryptor(privateKeyPath));
    }


    @Override
    public void postInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        registerFunctionMapper(processEngineConfiguration);
    }

    private void registerFunctionMapper(ProcessEngineConfigurationImpl processEngineConfiguration) {
        SpinEncryptionFunctionMapper.processInstanceSpinVariableDecryptor = this.processInstanceSpinVariableDecryptor;
        SpinEncryptionFunctionMapper.processInstanceSpinVariableEncryptor = this.processInstanceSpinVariableEncryptor;


        processEngineConfiguration.setScriptingEnvironment(new EncryptionScriptingEnvironment(
                processEngineConfiguration,
                this.processInstanceSpinVariableDecryptor,
                this.processInstanceSpinVariableEncryptor
        ));


        processEngineConfiguration.getExpressionManager()
                .addFunctionMapper(new SpinEncryptionFunctionMapper());
    }


}
