/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.storage.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import io.digdag.client.config.Config;
import io.digdag.spi.Storage;
import io.digdag.spi.StorageFactory;
import io.digdag.storage.s3.S3Storage;

public class S3StorageFactory
implements StorageFactory {
    public String getType() {
        return "s3";
    }

    public Storage newStorage(Config config) {
        AmazonS3Client client = new AmazonS3Client(S3StorageFactory.buildCredentialsProvider(config), S3StorageFactory.buildClientConfiguration(config));
        if (config.has("endpoint")) {
            client.setEndpoint((String)config.get("endpoint", String.class));
        }
        if (config.has("path-style-access")) {
            client.setS3ClientOptions(S3ClientOptions.builder().setPathStyleAccess(((Boolean)config.get("path-style-access", Boolean.class, (Object)false)).booleanValue()).build());
        }
        String bucket = (String)config.get("bucket", String.class);
        return new S3Storage(config, client, bucket);
    }

    private static ClientConfiguration buildClientConfiguration(Config config) {
        return new ClientConfiguration();
    }

    private static AWSCredentialsProvider buildCredentialsProvider(Config config) {
        if (config.has("credentials.file")) {
            return new PropertiesFileCredentialsProvider((String)config.get("credentials.file", String.class));
        }
        if (config.has("credentials.access-key-id")) {
            final BasicAWSCredentials creds = new BasicAWSCredentials((String)config.get("credentials.access-key-id", String.class), (String)config.get("credentials.secret-access-key", String.class));
            return new AWSCredentialsProvider(){

                public AWSCredentials getCredentials() {
                    return creds;
                }

                public void refresh() {
                }
            };
        }
        return new DefaultAWSCredentialsProviderChain();
    }
}

