/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.storage.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.google.common.io.ByteStreams;
import io.digdag.client.DigdagClient;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigFactory;
import io.digdag.core.storage.StorageManager;
import io.digdag.spi.Storage;
import io.digdag.spi.StorageObjectSummary;
import io.digdag.storage.s3.S3StorageFactory;
import io.digdag.util.Md5CountInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class S3StorageTest {
    private static final String TEST_S3_ENDPOINT = System.getenv("TEST_S3_ENDPOINT");
    private static final String TEST_S3_ACCESS_KEY_ID = System.getenv().getOrDefault("TEST_S3_ACCESS_KEY_ID", "test");
    private static final String TEST_S3_SECRET_ACCESS_KEY = System.getenv().getOrDefault("TEST_S3_SECRET_ACCESS_KEY", "test");
    private Storage storage;

    @Before
    public void setUp() throws Exception {
        Assume.assumeThat((Object)TEST_S3_ENDPOINT, (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        BasicAWSCredentials credentials = new BasicAWSCredentials(TEST_S3_ACCESS_KEY_ID, TEST_S3_SECRET_ACCESS_KEY);
        AmazonS3Client s3 = new AmazonS3Client((AWSCredentials)credentials);
        s3.setEndpoint(TEST_S3_ENDPOINT);
        String bucket = UUID.randomUUID().toString();
        s3.createBucket(bucket);
        ConfigFactory cf = new ConfigFactory(DigdagClient.objectMapper());
        Config config = cf.create().set("endpoint", (Object)TEST_S3_ENDPOINT).set("bucket", (Object)bucket).set("credentials.access-key-id", (Object)TEST_S3_ACCESS_KEY_ID).set("credentials.secret-access-key", (Object)TEST_S3_SECRET_ACCESS_KEY);
        this.storage = new S3StorageFactory().newStorage(config);
    }

    @Test
    public void putReturnsMd5() throws Exception {
        String checksum1 = this.storage.put("key1", 10L, S3StorageTest.contents("0123456789"));
        String checksum2 = this.storage.put("key2", 5L, S3StorageTest.contents("01234"));
        MatcherAssert.assertThat((Object)checksum1, (Matcher)Matchers.is((Object)S3StorageTest.md5hex("0123456789")));
        MatcherAssert.assertThat((Object)checksum2, (Matcher)Matchers.is((Object)S3StorageTest.md5hex("01234")));
    }

    @Test
    public void putGet() throws Exception {
        this.storage.put("key/file/1", 3L, S3StorageTest.contents("xxx"));
        this.storage.put("key/file/2", 1L, S3StorageTest.contents("a"));
        this.storage.put("key/file/3", 4L, S3StorageTest.contents("data"));
        MatcherAssert.assertThat((Object)S3StorageTest.readString(this.storage.open("key/file/1").getContentInputStream()), (Matcher)Matchers.is((Object)"xxx"));
        MatcherAssert.assertThat((Object)S3StorageTest.readString(this.storage.open("key/file/2").getContentInputStream()), (Matcher)Matchers.is((Object)"a"));
        MatcherAssert.assertThat((Object)S3StorageTest.readString(this.storage.open("key/file/3").getContentInputStream()), (Matcher)Matchers.is((Object)"data"));
    }

    @Test
    public void listAll() throws Exception {
        this.storage.put("key/file/1", 3L, S3StorageTest.contents("xxx"));
        this.storage.put("key/file/2", 1L, S3StorageTest.contents("1"));
        this.storage.put("key/file/3", 2L, S3StorageTest.contents("12"));
        ArrayList all = new ArrayList();
        this.storage.list("key", chunk -> all.addAll(chunk));
        MatcherAssert.assertThat((Object)all.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((StorageObjectSummary)all.get(0)).getKey(), (Matcher)Matchers.is((Object)"key/file/1"));
        MatcherAssert.assertThat((Object)((StorageObjectSummary)all.get(0)).getContentLength(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((Object)((StorageObjectSummary)all.get(1)).getKey(), (Matcher)Matchers.is((Object)"key/file/2"));
        MatcherAssert.assertThat((Object)((StorageObjectSummary)all.get(1)).getContentLength(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)((StorageObjectSummary)all.get(2)).getKey(), (Matcher)Matchers.is((Object)"key/file/3"));
        MatcherAssert.assertThat((Object)((StorageObjectSummary)all.get(2)).getContentLength(), (Matcher)Matchers.is((Object)2L));
    }

    @Test
    public void listWithPrefix() throws Exception {
        this.storage.put("key1", 1L, S3StorageTest.contents("0"));
        this.storage.put("test/file/1", 1L, S3StorageTest.contents("1"));
        this.storage.put("test/file/2", 1L, S3StorageTest.contents("1"));
        ArrayList all = new ArrayList();
        this.storage.list("test", chunk -> all.addAll(chunk));
        MatcherAssert.assertThat((Object)all.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((StorageObjectSummary)all.get(0)).getKey(), (Matcher)Matchers.is((Object)"test/file/1"));
        MatcherAssert.assertThat((Object)((StorageObjectSummary)all.get(1)).getKey(), (Matcher)Matchers.is((Object)"test/file/2"));
    }

    private static Storage.UploadStreamProvider contents(String data) {
        return () -> new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
    }

    private static String md5hex(String data) {
        return S3StorageTest.md5hex(data.getBytes(StandardCharsets.UTF_8));
    }

    private static String md5hex(byte[] data) {
        return StorageManager.encodeHex((byte[])Md5CountInputStream.digestMd5((byte[])data));
    }

    private static String readString(InputStream in) throws IOException {
        return new String(ByteStreams.toByteArray((InputStream)in), StandardCharsets.UTF_8);
    }
}

