/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server;

import com.google.common.base.Optional;
import io.digdag.client.DigdagClient;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigFactory;
import io.digdag.spi.Authenticator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class AuthenticatorTest {
    private static final ConfigFactory CF = new ConfigFactory(DigdagClient.objectMapper());

    @Test
    public void reject() throws Exception {
        Authenticator.Result rejection = Authenticator.Result.reject((String)"foobar");
        Assert.assertThat((Object)rejection.isAccepted(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)rejection.getErrorMessage(), (Matcher)Matchers.is((Object)"foobar"));
        Assert.assertThat((Object)rejection.isAdmin(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void accept() throws Exception {
        Authenticator.Result acceptance = Authenticator.Result.accept((int)17);
        Assert.assertThat((Object)acceptance.isAccepted(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)acceptance.getSiteId(), (Matcher)Matchers.is((Object)17));
        Assert.assertThat((Object)acceptance.getUserInfo(), (Matcher)Matchers.is((Object)Optional.absent()));
        Assert.assertThat((Object)acceptance.isAdmin(), (Matcher)Matchers.is((Object)false));
        Config userinfo = CF.create();
        userinfo.set("foo", (Object)"bar");
        Authenticator.Result acceptance2 = Authenticator.Result.accept((int)17, (Config)userinfo);
        Assert.assertThat((Object)acceptance2.isAccepted(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)acceptance2.getSiteId(), (Matcher)Matchers.is((Object)17));
        Assert.assertThat((Object)acceptance2.getUserInfo(), (Matcher)Matchers.is((Object)Optional.of((Object)userinfo)));
        Assert.assertThat((Object)acceptance2.isAdmin(), (Matcher)Matchers.is((Object)false));
        userinfo = CF.create();
        userinfo.set("foo", (Object)"bar");
        acceptance2 = Authenticator.Result.accept((int)17, (Optional)Optional.of((Object)userinfo));
        Assert.assertThat((Object)acceptance2.isAccepted(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)acceptance2.getSiteId(), (Matcher)Matchers.is((Object)17));
        Assert.assertThat((Object)acceptance2.getUserInfo(), (Matcher)Matchers.is((Object)Optional.of((Object)userinfo)));
        Assert.assertThat((Object)acceptance2.isAdmin(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void admin() throws Exception {
        Authenticator.Result acceptance = Authenticator.Result.builder().siteId(17).isAdmin(true).build();
        Assert.assertThat((Object)acceptance.isAccepted(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)acceptance.getSiteId(), (Matcher)Matchers.is((Object)17));
        Assert.assertThat((Object)acceptance.isAdmin(), (Matcher)Matchers.is((Object)true));
    }
}

