/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import io.digdag.client.DigdagClient;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigFactory;
import io.digdag.server.AuthRequestFilter;
import io.digdag.spi.Authenticator;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AuthRequestFilterTest {
    private static final ConfigFactory CONFIG_FACTORY = new ConfigFactory(DigdagClient.objectMapper());
    @Mock
    ContainerRequestContext containerRequestContext;
    @Mock
    Authenticator authenticator;
    @Mock
    UriInfo uriInfo;
    private AuthRequestFilter authRequestFilter;

    @Before
    public void setUp() throws Exception {
        this.authRequestFilter = new AuthRequestFilter(this.authenticator, CONFIG_FACTORY);
    }

    @Test
    public void verifyThatRequestsAreAuthenticated() throws Exception {
        this.verifyThatMethodIsAuthenticated("HEAD");
        this.verifyThatMethodIsAuthenticated("GET");
        this.verifyThatMethodIsAuthenticated("PUT");
        this.verifyThatMethodIsAuthenticated("POST");
        this.verifyThatMethodIsAuthenticated("DELETE");
        this.verifyThatMethodIsAuthenticated("BAZ");
    }

    @Test
    public void verifyThatOptionsRequestsArePassed() throws Exception {
        this.verifyThatMethodIsPassed("OPTIONS");
    }

    @Test
    public void verifyThatTraceRequestsArePassed() throws Exception {
        this.verifyThatMethodIsPassed("TRACE");
    }

    @Test
    public void verifyThatVersionEndpointIsPassed() throws Exception {
        Mockito.when((Object)this.uriInfo.getPath()).thenReturn((Object)"/api/version");
        Mockito.when((Object)this.containerRequestContext.getUriInfo()).thenReturn((Object)this.uriInfo);
        Mockito.when((Object)this.containerRequestContext.getMethod()).thenReturn((Object)"GET");
        this.authRequestFilter.filter(this.containerRequestContext);
        ((ContainerRequestContext)Mockito.verify((Object)this.containerRequestContext, (VerificationMode)Mockito.never())).abortWith((Response)Matchers.any(Response.class));
        ((Authenticator)Mockito.verify((Object)this.authenticator, (VerificationMode)Mockito.never())).authenticate((ContainerRequestContext)Matchers.any(ContainerRequestContext.class));
    }

    private void verifyThatMethodIsPassed(String method) {
        Mockito.when((Object)this.containerRequestContext.getMethod()).thenReturn((Object)method);
        this.authRequestFilter.filter(this.containerRequestContext);
        ((ContainerRequestContext)Mockito.verify((Object)this.containerRequestContext, (VerificationMode)Mockito.never())).abortWith((Response)Matchers.any(Response.class));
        ((Authenticator)Mockito.verify((Object)this.authenticator, (VerificationMode)Mockito.never())).authenticate((ContainerRequestContext)Matchers.any(ContainerRequestContext.class));
    }

    private void verifyThatMethodIsAuthenticated(String method) {
        Mockito.reset((Object[])new Authenticator[]{this.authenticator});
        Mockito.reset((Object[])new ContainerRequestContext[]{this.containerRequestContext});
        Mockito.reset((Object[])new UriInfo[]{this.uriInfo});
        Mockito.when((Object)this.uriInfo.getPath()).thenReturn((Object)"/api/foobar");
        Mockito.when((Object)this.containerRequestContext.getUriInfo()).thenReturn((Object)this.uriInfo);
        Mockito.when((Object)this.authenticator.authenticate(this.containerRequestContext)).thenReturn((Object)Authenticator.Result.reject((String)"reject"));
        Mockito.when((Object)this.containerRequestContext.getMethod()).thenReturn((Object)method);
        this.authRequestFilter.filter(this.containerRequestContext);
        ((ContainerRequestContext)Mockito.verify((Object)this.containerRequestContext)).getMethod();
        ((Authenticator)Mockito.verify((Object)this.authenticator)).authenticate(this.containerRequestContext);
        ((ContainerRequestContext)Mockito.verify((Object)this.containerRequestContext)).abortWith((Response)Matchers.any(Response.class));
        Mockito.reset((Object[])new Authenticator[]{this.authenticator});
        Mockito.reset((Object[])new ContainerRequestContext[]{this.containerRequestContext});
        Config userInfo = CONFIG_FACTORY.create();
        Supplier secrets = () -> ImmutableMap.of((Object)"secret", (Object)"value");
        Authenticator.Result acceptance = Authenticator.Result.builder().siteId(17).userInfo(userInfo).secrets(secrets).isAdmin(true).build();
        Mockito.when((Object)this.containerRequestContext.getUriInfo()).thenReturn((Object)this.uriInfo);
        Mockito.when((Object)this.authenticator.authenticate(this.containerRequestContext)).thenReturn((Object)acceptance);
        Mockito.when((Object)this.containerRequestContext.getMethod()).thenReturn((Object)method);
        this.authRequestFilter.filter(this.containerRequestContext);
        ((ContainerRequestContext)Mockito.verify((Object)this.containerRequestContext)).getMethod();
        ((Authenticator)Mockito.verify((Object)this.authenticator)).authenticate(this.containerRequestContext);
        ((ContainerRequestContext)Mockito.verify((Object)this.containerRequestContext, (VerificationMode)Mockito.never())).abortWith((Response)Matchers.any(Response.class));
        ((ContainerRequestContext)Mockito.verify((Object)this.containerRequestContext)).setProperty("siteId", (Object)17);
        ((ContainerRequestContext)Mockito.verify((Object)this.containerRequestContext)).setProperty("userInfo", (Object)userInfo);
        ((ContainerRequestContext)Mockito.verify((Object)this.containerRequestContext)).setProperty("secrets", (Object)secrets);
        ((ContainerRequestContext)Mockito.verify((Object)this.containerRequestContext)).setProperty("admin", (Object)true);
    }
}

