/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import com.google.common.base.Optional;
import io.digdag.client.config.ConfigException;
import io.digdag.util.UserSecretTemplate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class UserSecretTemplateTest {
    @Test
    public void testCorrectTemplates() throws Exception {
        Assert.assertThat((Object)UserSecretTemplate.of((String)"${}").format(key -> Optional.of((Object)"bar")), (Matcher)Matchers.is((Object)"${}"));
        Assert.assertThat((Object)UserSecretTemplate.of((String)"${foo}").format(key -> Optional.of((Object)"bar")), (Matcher)Matchers.is((Object)"${foo}"));
        Assert.assertThat((Object)UserSecretTemplate.of((String)"${secret:foo}").format(key -> Optional.of((Object)"bar")), (Matcher)Matchers.is((Object)"bar"));
        Assert.assertThat((Object)UserSecretTemplate.of((String)"${secret:foo}").format(key -> Optional.of((Object)"$b$a$r$")), (Matcher)Matchers.is((Object)"$b$a$r$"));
        Assert.assertThat((Object)UserSecretTemplate.of((String)"${secret:foo}").format(key -> Optional.of((Object)"\\$b\\$a\\$r\\$")), (Matcher)Matchers.is((Object)"\\$b\\$a\\$r\\$"));
        Assert.assertThat((Object)UserSecretTemplate.of((String)"hello ${secret:foo} world").format(key -> Optional.of((Object)"bar")), (Matcher)Matchers.is((Object)"hello bar world"));
        Assert.assertThat((Object)UserSecretTemplate.of((String)"hello ${secret:foo} world ${secret:bar}").format(key -> {
            switch (key) {
                case "foo": {
                    return Optional.of((Object)"fooval");
                }
                case "bar": {
                    return Optional.of((Object)"barval");
                }
            }
            throw new AssertionError();
        }), (Matcher)Matchers.is((Object)"hello fooval world barval"));
    }

    @Test
    public void testInvalidTemplates() throws Exception {
        try {
            UserSecretTemplate.of((String)"${secrets:foo}");
            Assert.fail();
        }
        catch (ConfigException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Invalid parametrization: '${secrets:foo}'"));
        }
        try {
            UserSecretTemplate.of((String)"${bar:foo}");
            Assert.fail();
        }
        catch (ConfigException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Invalid parametrization: '${bar:foo}'"));
        }
        try {
            UserSecretTemplate.of((String)"${:foo}");
            Assert.fail();
        }
        catch (ConfigException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Invalid parametrization: '${:foo}'"));
        }
    }
}

