/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.guice.rs.server.jmx;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.digdag.guice.rs.server.jmx.JmxConfig;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.server.RemoteObject;
import java.util.Properties;
import java.util.stream.IntStream;
import javax.annotation.PostConstruct;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxAgent {
    private static final Logger logger = LoggerFactory.getLogger(JmxAgent.class);
    private final boolean enabled;
    private final int port;

    @Inject
    public JmxAgent(JmxConfig jmxConfig) {
        this.enabled = jmxConfig.isEnabled();
        this.port = this.enabled ? jmxConfig.getPort() : 0;
    }

    @PostConstruct
    public void start() {
        if (this.enabled) {
            JmxAgent.startAgent(this.port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startAgent(int port) {
        try {
            Class.forName("sun.management.Agent");
            try {
                JmxAgent.startAgent8(port);
                return;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        catch (ReflectiveOperationException e) {
            Properties props = new Properties();
            props.setProperty("com.sun.management.jmxremote.port", Integer.toString(port));
            props.setProperty("com.sun.management.jmxremote.rmi.port", Integer.toString(port));
            props.setProperty("com.sun.management.jmxremote.authenticate", "false");
            props.setProperty("com.sun.management.jmxremote.ssl", "false");
            try {
                long pid = JmxAgent.getPid();
                Object virtualMachine = JmxAgent.invokeStaticMethod("com.sun.tools.attach.VirtualMachine", "attach", String.class, Long.toString(pid));
                try {
                    JmxAgent.invokeMethod(virtualMachine, "startLocalManagementAgent", new Object[0]);
                    JmxAgent.invokeMethod(virtualMachine, "startManagementAgent", Properties.class, props);
                }
                finally {
                    JmxAgent.invokeMethod(virtualMachine, "detach", new Object[0]);
                }
            }
            catch (Exception e2) {
                if (e2.getCause() instanceof IOException) {
                    throw new RuntimeException("Failed to start JMX agent. Please make sure that you add '-Djdk.attach.allowAttachSelf=true' to the command line options of java or to JDK_JAVA_OPTIONS environment variable.", e2.getCause());
                }
                throw Throwables.propagate((Throwable)e2);
            }
            try {
                JMXServiceURL url = new JMXServiceURL("rmi", null, port);
                int actualPort = url.getPort();
                logger.info("JMX agent started on port {}", (Object)actualPort);
            }
            catch (Exception e3) {
                logger.warn("Failed to determine JMX port", (Throwable)e3);
            }
            return;
        }
    }

    private static long getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int index = name.indexOf(64);
        return Long.parseLong(name.substring(0, index));
    }

    private static void startAgent8(int port) throws ReflectiveOperationException {
        System.setProperty("com.sun.management.jmxremote", "true");
        System.setProperty("com.sun.management.jmxremote.port", Integer.toString(port));
        System.setProperty("com.sun.management.jmxremote.rmi.port", Integer.toString(port));
        System.setProperty("com.sun.management.jmxremote.authenticate", "false");
        System.setProperty("com.sun.management.jmxremote.ssl", "false");
        JmxAgent.invokeStaticMethod("sun.management.Agent", "startAgent", new Object[0]);
        try {
            int actualPort = JmxAgent.getJmxRegistryPort8(port);
            logger.info("JMX agent started on port {}", (Object)actualPort);
        }
        catch (Exception e) {
            logger.warn("Failed to determine JMX port", (Throwable)e);
        }
    }

    private static int getJmxRegistryPort8(int defaultPort) throws ReflectiveOperationException {
        Object jmxServer = JmxAgent.getDeclaredStaticField("sun.management.Agent", "jmxServer");
        if (jmxServer == null) {
            logger.warn("Failed to determine JMX port: sun.management.Agent.jmxServer field is null");
        } else {
            Object registry = JmxAgent.getDeclaredStaticField("sun.management.jmxremote.ConnectorBootstrap", "registry");
            if (registry == null) {
                logger.warn("Failed to determine JMX port: sun.management.jmxremote.ConnectorBootstrap.registry field is null");
            } else {
                return (Integer)JmxAgent.invokeMethod(JmxAgent.invokeMethod(((RemoteObject)RemoteObject.class.cast(registry)).getRef(), "getLiveRef", new Object[0]), "getPort", new Object[0]);
            }
        }
        return defaultPort;
    }

    private static Object getDeclaredStaticField(String className, String fieldName) throws ReflectiveOperationException {
        Class<?> clazz = Class.forName(className);
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(clazz);
    }

    private static Object invokeStaticMethod(String className, String methodName, Object ... typesArgs) throws ReflectiveOperationException {
        Class[] types = (Class[])IntStream.range(0, typesArgs.length).filter(i -> i % 2 == 0).mapToObj(i -> (Class)typesArgs[i]).toArray(Class[]::new);
        Object[] args = IntStream.range(0, typesArgs.length).filter(i -> i % 2 == 1).mapToObj(i -> typesArgs[i]).toArray(Object[]::new);
        Method method = Class.forName(className).getMethod(methodName, types);
        return method.invoke(null, args);
    }

    private static Object invokeMethod(Object object, String methodName, Object ... typesArgs) throws ReflectiveOperationException {
        Class[] types = (Class[])IntStream.range(0, typesArgs.length).filter(i -> i % 2 == 0).mapToObj(i -> (Class)typesArgs[i]).toArray(Class[]::new);
        Object[] args = IntStream.range(0, typesArgs.length).filter(i -> i % 2 == 1).mapToObj(i -> typesArgs[i]).toArray(Object[]::new);
        Method method = object.getClass().getMethod(methodName, types);
        return method.invoke(object, args);
    }
}

