/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.guice.rs.server;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import io.digdag.guice.rs.server.ServerLifeCycleManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ServerLifeCycleModule
implements Module {
    private final List<Object> earlyInjected = new ArrayList<Object>();
    private final AtomicReference<ServerLifeCycleManager> lifeCycleManagerRef = new AtomicReference<Object>(null);

    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bindListener(Matchers.any(), new TypeListener(){

            public <T> void hear(TypeLiteral<T> type, TypeEncounter<T> encounter) {
                encounter.register(new InjectionListener<T>(){

                    public void afterInjection(T obj) {
                        ServerLifeCycleManager initialized = (ServerLifeCycleManager)ServerLifeCycleModule.this.lifeCycleManagerRef.get();
                        if (initialized == null) {
                            ServerLifeCycleModule.this.earlyInjected.add(obj);
                        } else {
                            try {
                                initialized.manageInstance(obj);
                            }
                            catch (Exception e) {
                                throw new Error(e);
                            }
                        }
                    }
                });
            }
        });
    }

    @Provides
    @Singleton
    public ServerLifeCycleManager getServerManager() throws Exception {
        ServerLifeCycleManager initialized = new ServerLifeCycleManager();
        this.lifeCycleManagerRef.set(initialized);
        for (Object delayed : this.earlyInjected) {
            initialized.manageInstance(delayed);
        }
        this.earlyInjected.clear();
        return initialized;
    }
}

