/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.guice.rs.server;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.digdag.guice.rs.server.PostStart;
import io.digdag.guice.rs.server.PreStop;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;

public class ServerLifeCycleManager {
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final Queue<ManagedInstance> managedInstances = new ConcurrentLinkedQueue<ManagedInstance>();

    public void manageInstance(Object obj) throws Exception {
        State currentState = this.state.get();
        if (currentState.isSameOrAfter(State.STOPPED)) {
            return;
        }
        ImmutableList postStartMethods = ServerLifeCycleManager.getAnnotatedMethods(obj.getClass(), PostStart.class);
        List<Method> preStopMethods = ServerLifeCycleManager.getAnnotatedMethods(obj.getClass(), PreStop.class);
        if (currentState.isSameOrAfter(State.STOPPING)) {
            ServerLifeCycleManager.invokeMethods(obj, preStopMethods);
            return;
        }
        if (currentState.isSameOrAfter(State.STARTED)) {
            ServerLifeCycleManager.invokeMethods(obj, postStartMethods);
            postStartMethods = ImmutableList.of();
        }
        if (!postStartMethods.isEmpty() || !preStopMethods.isEmpty()) {
            this.managedInstances.add(new ManagedInstance(obj, (List<Method>)postStartMethods, preStopMethods));
        }
    }

    public void postStart() throws Exception {
        if (!this.state.compareAndSet(State.LATENT, State.STARTING)) {
            return;
        }
        for (ManagedInstance managed : this.managedInstances) {
            ServerLifeCycleManager.invokeMethods(managed.object, managed.postStartMethods);
            if (!managed.postStartCalled()) continue;
            this.managedInstances.remove(managed);
        }
        this.state.set(State.STARTED);
    }

    public void preStop() throws Exception {
        ManagedInstance managed;
        if (!this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            return;
        }
        ArrayList<ManagedInstance> moved = new ArrayList<ManagedInstance>();
        while ((managed = this.managedInstances.poll()) != null) {
            moved.add(managed);
        }
        List reversed = Lists.reverse(moved);
        for (ManagedInstance managed2 : reversed) {
            ServerLifeCycleManager.invokeMethods(managed2.object, managed2.preStopMethods);
        }
        this.state.set(State.STOPPED);
    }

    private static List<Method> getAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return ServerLifeCycleManager.getAnnotatedMethodsRecursively(clazz, annotationClass, new ArrayList<Method>(), new HashSet<String>());
    }

    private static List<Method> getAnnotatedMethodsRecursively(Class<?> clazz, Class<? extends Annotation> annotationClass, List<Method> list, Set<String> usedNames) {
        if (clazz == null) {
            return list;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.isSynthetic() || method.isBridge() || !method.isAnnotationPresent(annotationClass) || usedNames.contains(method.getName())) continue;
            if (method.getParameterTypes().length != 0) {
                throw new UnsupportedOperationException(String.format("@PostStart/@PreStop methods cannot have arguments: %s", method.getDeclaringClass().getName() + "." + method.getName() + "(...)"));
            }
            method.setAccessible(true);
            usedNames.add(method.getName());
            list.add(method);
        }
        ServerLifeCycleManager.getAnnotatedMethodsRecursively(clazz.getSuperclass(), annotationClass, list, usedNames);
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            ServerLifeCycleManager.getAnnotatedMethodsRecursively(genericDeclaration, annotationClass, list, usedNames);
        }
        return list;
    }

    private static void invokeMethods(Object obj, List<Method> methods) throws Exception {
        for (Method method : methods) {
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                Throwables.propagateIfPossible((Throwable)cause);
                Throwables.propagateIfInstanceOf((Throwable)cause, Exception.class);
                throw Throwables.propagate((Throwable)cause);
            }
        }
    }

    private static enum State {
        LATENT(0),
        STARTING(1),
        STARTED(2),
        STOPPING(3),
        STOPPED(4);

        private final int index;

        private State(int index) {
            this.index = index;
        }

        public boolean isSameOrAfter(State another) {
            return another.index <= this.index;
        }
    }

    private static class ManagedInstance {
        final Object object;
        List<Method> postStartMethods;
        final List<Method> preStopMethods;

        ManagedInstance(Object object, List<Method> postStartMethods, List<Method> preStopMethods) {
            this.object = object;
            this.postStartMethods = postStartMethods;
            this.preStopMethods = preStopMethods;
        }

        boolean postStartCalled() {
            this.postStartMethods = ImmutableList.of();
            return this.preStopMethods.isEmpty();
        }
    }
}

