/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.client.config.ConfigUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigTest {
    private Config config;

    @Before
    public void setUp() {
        this.config = ConfigUtils.newConfig();
    }

    @Test
    public void testSetGetPrimitives() {
        this.config.set("int", (Object)1);
        this.config.set("str", (Object)"s");
        this.config.set("bool", (Object)true);
        Assert.assertThat((Object)this.config.get("int", Byte.TYPE), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.config.get("int", Short.TYPE), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.config.get("int", Integer.TYPE), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.config.get("int", Long.TYPE), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)this.config.get("int", Byte.class), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.config.get("int", Short.class), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.config.get("int", Integer.class), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.config.get("int", Long.class), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)this.config.get("str", String.class), (Matcher)Matchers.is((Object)"s"));
        Assert.assertThat((Object)this.config.get("bool", Boolean.TYPE), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.config.get("bool", Boolean.class), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void verifyAutoStringConvert() {
        this.config.set("int", (Object)1);
        this.config.set("float", (Object)0.2);
        this.config.set("bool", (Object)true);
        Assert.assertThat((Object)this.config.get("int", String.class), (Matcher)Matchers.is((Object)"1"));
        Assert.assertThat((Object)this.config.get("float", String.class), (Matcher)Matchers.is((Object)"0.2"));
        Assert.assertThat((Object)this.config.get("bool", String.class), (Matcher)Matchers.is((Object)"true"));
    }

    @Test
    public void verifySetGetNested() {
        Config nested = ConfigUtils.newConfig().set("k", (Object)ConfigUtils.newConfig());
        this.config.set("nested", (Object)nested);
        Assert.assertThat((Object)this.config.deepCopy().getNested("nested"), (Matcher)Matchers.is((Object)nested));
        Assert.assertThat((Object)this.config.deepCopy().getNestedOrGetEmpty("nested"), (Matcher)Matchers.is((Object)nested));
        Assert.assertThat((Object)this.config.deepCopy().getNestedOrSetEmpty("nested"), (Matcher)Matchers.is((Object)nested));
        Assert.assertThat((Object)this.config.deepCopy().getOptionalNested("nested"), (Matcher)Matchers.is((Object)Optional.of((Object)nested)));
        Assert.assertThat((Object)this.config.deepCopy().parseNested("nested"), (Matcher)Matchers.is((Object)nested));
        Assert.assertThat((Object)this.config.deepCopy().parseNestedOrGetEmpty("nested"), (Matcher)Matchers.is((Object)nested));
    }

    @Test
    public void verifySetGetNestedNotSet() {
        Config empty = ConfigUtils.newConfig();
        this.assertConfigException(() -> this.config.deepCopy().getNested("nested"));
        Assert.assertThat((Object)this.config.deepCopy().getNestedOrGetEmpty("nested"), (Matcher)Matchers.is((Object)empty));
        Assert.assertThat((Object)this.config.deepCopy().getNestedOrSetEmpty("nested"), (Matcher)Matchers.is((Object)empty));
        Assert.assertThat((Object)this.config.deepCopy().getOptionalNested("nested"), (Matcher)Matchers.is((Object)Optional.absent()));
        this.assertConfigException(() -> this.config.deepCopy().parseNested("nested"));
        Assert.assertThat((Object)this.config.deepCopy().parseNestedOrGetEmpty("nested"), (Matcher)Matchers.is((Object)empty));
    }

    @Test
    public void verifyParseNested() {
        Config nested = ConfigUtils.newConfig().set("k", (Object)ConfigUtils.newConfig());
        this.config.set("nested", (Object)nested.toString());
        this.assertConfigException(() -> this.config.deepCopy().getNested("nested"));
        this.assertConfigException(() -> this.config.deepCopy().getNestedOrGetEmpty("nested"));
        this.assertConfigException(() -> this.config.deepCopy().getNestedOrSetEmpty("nested"));
        this.assertConfigException(() -> this.config.deepCopy().getOptionalNested("nested"));
        Assert.assertThat((Object)this.config.deepCopy().parseNested("nested"), (Matcher)Matchers.is((Object)nested));
        Assert.assertThat((Object)this.config.deepCopy().parseNestedOrGetEmpty("nested"), (Matcher)Matchers.is((Object)nested));
    }

    @Test
    public void verifySetGetList() {
        List<String> nested = Arrays.asList("a", "b");
        this.config.set("nested", nested);
        Assert.assertThat((Object)this.config.deepCopy().getList("nested", String.class), (Matcher)Matchers.is(nested));
        Assert.assertThat((Object)this.config.deepCopy().getList("nested", JsonNode.class), (Matcher)Matchers.is(nested.stream().map(TextNode::valueOf).collect(Collectors.toList())));
        Assert.assertThat((Object)this.config.deepCopy().getListOrEmpty("nested", String.class), (Matcher)Matchers.is(nested));
        Assert.assertThat((Object)this.config.deepCopy().getListOrEmpty("nested", JsonNode.class), (Matcher)Matchers.is(nested.stream().map(TextNode::valueOf).collect(Collectors.toList())));
        Assert.assertThat((Object)this.config.deepCopy().parseList("nested", String.class), (Matcher)Matchers.is(nested));
        Assert.assertThat((Object)this.config.deepCopy().parseList("nested", JsonNode.class), (Matcher)Matchers.is(nested.stream().map(TextNode::valueOf).collect(Collectors.toList())));
        Assert.assertThat((Object)this.config.deepCopy().parseListOrGetEmpty("nested", String.class), (Matcher)Matchers.is(nested));
        Assert.assertThat((Object)this.config.deepCopy().parseListOrGetEmpty("nested", JsonNode.class), (Matcher)Matchers.is(nested.stream().map(TextNode::valueOf).collect(Collectors.toList())));
    }

    @Test
    public void verifySetGetListNotSet() {
        List<String> empty = Arrays.asList(new String[0]);
        this.assertConfigException(() -> this.config.deepCopy().getList("nested", String.class));
        this.assertConfigException(() -> this.config.deepCopy().getList("nested", JsonNode.class));
        Assert.assertThat((Object)this.config.deepCopy().getListOrEmpty("nested", String.class), (Matcher)Matchers.is(empty));
        this.assertConfigException(() -> this.config.deepCopy().parseList("nested", String.class));
        this.assertConfigException(() -> this.config.deepCopy().parseList("nested", JsonNode.class));
        Assert.assertThat((Object)this.config.deepCopy().parseListOrGetEmpty("nested", String.class), (Matcher)Matchers.is(empty));
    }

    @Test
    public void verifyParseList() {
        List<String> nested = Arrays.asList("a", "b");
        this.config.set("nested", (Object)"[\"a\", \"b\"]");
        this.assertConfigException(() -> this.config.deepCopy().getList("nested", String.class));
        this.assertConfigException(() -> this.config.deepCopy().getList("nested", JsonNode.class));
        this.assertConfigException(() -> this.config.deepCopy().getListOrEmpty("nested", String.class));
        this.assertConfigException(() -> this.config.deepCopy().getListOrEmpty("nested", JsonNode.class));
        Assert.assertThat((Object)this.config.deepCopy().parseList("nested", String.class), (Matcher)Matchers.is(nested));
        Assert.assertThat((Object)this.config.deepCopy().parseList("nested", JsonNode.class), (Matcher)Matchers.is(nested.stream().map(TextNode::valueOf).collect(Collectors.toList())));
        Assert.assertThat((Object)this.config.deepCopy().parseListOrGetEmpty("nested", String.class), (Matcher)Matchers.is(nested));
        Assert.assertThat((Object)this.config.deepCopy().parseListOrGetEmpty("nested", JsonNode.class), (Matcher)Matchers.is(nested.stream().map(TextNode::valueOf).collect(Collectors.toList())));
    }

    @Test
    public void verifyNullValueHandling() {
        this.config.set("null_value", (Object)JsonNodeFactory.instance.nullNode());
        Assert.assertThat((Object)this.config.getKeys(), (Matcher)Matchers.is(Arrays.asList("null_value")));
        Assert.assertThat((Object)this.config.has("null_value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.config.isEmpty(), (Matcher)Matchers.is((Object)false));
        this.assertConfigException(() -> {
            String cfr_ignored_0 = (String)this.config.get("null_value", String.class);
        }, "Parameter 'null_value' is required but null");
        this.assertConfigException(() -> {
            Integer cfr_ignored_0 = (Integer)this.config.get("null_value", Integer.class);
        }, "Parameter 'null_value' is required but null");
        Assert.assertThat((Object)this.config.get("null_value", String.class, (Object)"default"), (Matcher)Matchers.is((Object)"default"));
        Assert.assertThat((Object)this.config.get("null_value", Integer.class, (Object)100), (Matcher)Matchers.is((Object)100));
        Assert.assertThat((Object)this.config.getOptional("null_value", String.class), (Matcher)Matchers.is((Object)Optional.absent()));
        Assert.assertThat((Object)this.config.getOptional("null_value", Integer.class), (Matcher)Matchers.is((Object)Optional.absent()));
        Assert.assertThat((Object)this.config.getListOrEmpty("null_value", String.class), (Matcher)Matchers.is((Object)ImmutableList.of()));
        Assert.assertThat((Object)this.config.parseListOrGetEmpty("null_value", String.class), (Matcher)Matchers.is((Object)ImmutableList.of()));
        this.assertConfigException(() -> this.config.getList("null_value", String.class), "Parameter 'null_value' is required but null");
        this.assertConfigException(() -> this.config.parseList("null_value", String.class), "Parameter 'null_value' is required but null");
        Assert.assertThat((Object)this.config.getMapOrEmpty("null_value", String.class, String.class), (Matcher)Matchers.is((Object)ImmutableMap.of()));
        this.assertConfigException(() -> this.config.getMap("null_value", String.class, String.class), "Parameter 'null_value' is required but null");
        Assert.assertThat((Object)this.config.getNestedOrGetEmpty("null_value"), (Matcher)Matchers.is((Object)ConfigUtils.newConfig()));
        Assert.assertThat((Object)this.config.deepCopy().getNestedOrSetEmpty("null_value"), (Matcher)Matchers.is((Object)ConfigUtils.newConfig()));
        Assert.assertThat((Object)this.config.getOptionalNested("null_value"), (Matcher)Matchers.is((Object)Optional.absent()));
        Assert.assertThat((Object)this.config.parseNestedOrGetEmpty("null_value"), (Matcher)Matchers.is((Object)ConfigUtils.newConfig()));
        this.assertConfigException(() -> this.config.getNested("null_value"), "Parameter 'null_value' must be an object");
        this.assertConfigException(() -> this.config.parseNested("null_value"), "Parameter 'null_value' must be an object");
    }

    @Test
    public void testGetOptional() {
        this.config.set("str", (Object)"s");
        Assert.assertThat((Object)this.config.getOptional("str", JsonNode.class).transform(JsonNode::deepCopy), (Matcher)Matchers.is((Object)Optional.of((Object)TextNode.valueOf((String)"s"))));
    }

    private void assertConfigException(Runnable func) {
        try {
            func.run();
            Assert.fail();
        }
        catch (ConfigException ex) {
            Assert.assertTrue((boolean)true);
        }
    }

    private void assertConfigException(Runnable func, String message) {
        try {
            func.run();
            Assert.fail();
        }
        catch (ConfigException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)message));
        }
    }
}

