/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.config;

import io.digdag.client.config.ConfigKey;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ConfigKeyTest {
    @Test
    public void verifyParseAndToString() {
        ConfigKeyTest.assertReversible("a", 1);
        ConfigKeyTest.assertReversible("foo.bar", 2);
        ConfigKeyTest.assertReversible("foo.bar.baz", 3);
    }

    @Test
    public void rejectInvalids() {
        ConfigKeyTest.assertInvalid("");
        ConfigKeyTest.assertInvalid(".");
        ConfigKeyTest.assertInvalid("a.");
        ConfigKeyTest.assertInvalid(".a");
        ConfigKeyTest.assertInvalid("a..");
        ConfigKeyTest.assertInvalid("a..b");
        ConfigKeyTest.assertInvalid("a.b~");
        ConfigKeyTest.assertInvalid("x.\"abc\".x");
    }

    private static void assertReversible(String key, int count) {
        Assert.assertThat((Object)ConfigKey.parse((String)key).toString(), (Matcher)Matchers.is((Object)key));
        Assert.assertThat((Object)ConfigKey.parse((String)key).getNames().size(), (Matcher)Matchers.is((Object)count));
    }

    private static void assertInvalid(String key) {
        try {
            ConfigKey.parse((String)key);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)true);
        }
    }
}

