/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.google.common.base.Strings;
import io.digdag.client.api.SecretValidation;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SecretValidationTest {
    @Test
    public void isValidSecretKey() throws Exception {
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)""), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"."), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"0"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"0.foo"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"0234"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"0bar"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"012bar"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"foo.0"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"foo.1"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"foo.1.baz"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"foo..baz"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"\u2603"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"\ud83d\udca9"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"r\u00e4ksm\u00f6rg\u00e5s"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"f"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"foo"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"foo.b"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"foo.bar"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"foo.bar.baz"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)SecretValidation.isValidSecretKey((String)"a1.b2c.d3"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void isValidSecretValue() throws Exception {
        Assert.assertThat((Object)SecretValidation.isValidSecretValue((String)""), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)SecretValidation.isValidSecretValue((String)"foobar"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)SecretValidation.isValidSecretValue((String)"\ud83d\udca9"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)SecretValidation.isValidSecretValue((String)"r\u00e4ksm\u00f6rg\u00e5s"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)SecretValidation.isValidSecretValue((String)Strings.repeat((String)".", (int)16384)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)SecretValidation.isValidSecretValue((String)Strings.repeat((String)".", (int)16385)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)SecretValidation.isValidSecretValue((String)Strings.repeat((String)"\u2603", (int)5462)), (Matcher)Matchers.is((Object)false));
    }
}

