/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Optional;
import io.digdag.client.DigdagClient;
import io.digdag.client.api.Id;
import io.digdag.client.api.IdAndName;
import io.digdag.client.api.ImmutableRestRevision;
import io.digdag.client.api.ImmutableRestSessionAttempt;
import io.digdag.client.api.NameOptionalId;
import io.digdag.client.api.RestRevision;
import io.digdag.client.api.RestSessionAttempt;
import io.digdag.client.config.ConfigUtils;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ModelCompatibilityTest {
    private ObjectMapper mapper = DigdagClient.objectMapper();

    @Test
    public void testSessionAttemptIndex() throws Exception {
        ImmutableRestSessionAttempt attempt = RestSessionAttempt.builder().id(Id.of((String)"1")).index(3).project(IdAndName.of((Id)Id.of((String)"1"), (String)"p")).workflow(NameOptionalId.of((String)"w", (Optional)Optional.of((Object)Id.of((String)"1")))).sessionId(Id.of((String)"1")).sessionUuid(UUID.randomUUID()).sessionTime(OffsetDateTime.now(ZoneId.of("UTC"))).retryAttemptName(Optional.absent()).done(false).success(false).cancelRequested(false).params(ConfigUtils.newConfig()).createdAt(Instant.now()).finishedAt(Optional.absent()).build();
        Assert.assertThat((Object)attempt.getIndex(), (Matcher)Matchers.is((Object)3));
        String oldVersion = this.removeField(this.mapper.writeValueAsString((Object)attempt), "index");
        this.mapper.readValue(oldVersion, RestSessionAttempt.class);
    }

    @Test
    public void testRestRevisionDefaultUserInfo() throws Exception {
        ImmutableRestRevision rev = RestRevision.builder().revision("rev1").createdAt(Instant.now()).archiveType("none").archiveMd5(Optional.absent()).userInfo(ConfigUtils.newConfig()).build();
        String oldVersion = this.removeField(this.mapper.writeValueAsString((Object)rev), "userInfo");
        this.mapper.readValue(oldVersion, RestRevision.class);
    }

    private String removeField(String json, String field) throws IOException {
        ObjectNode node = (ObjectNode)this.mapper.readTree(json);
        Assert.assertThat((Object)(node.remove(field) == null ? 1 : 0), (Matcher)Matchers.is((Object)false));
        return this.mapper.writeValueAsString((Object)node);
    }
}

