/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client;

import io.digdag.client.DigdagVersion;
import io.digdag.client.Version;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class VersionTest {
    @Test
    public void testValidVersions() {
        this.assertValidVersion("0");
        this.assertValidVersion("1");
        this.assertValidVersion("10");
        this.assertValidVersion("0.2");
        this.assertValidVersion("0.23");
        this.assertValidVersion("0.4.5");
        this.assertValidVersion("0.4.56");
        this.assertValidVersion("0.4.50");
        this.assertValidVersion("0.0.6");
        this.assertValidVersion("0.0.6.7");
        this.assertValidVersion("8.9.10.11");
        this.assertValidVersion("0-SNAPSHOT");
        this.assertValidVersion("0.8.32-20170117T115910-a60cad1343c71489d752f39250470e10109e3425");
        this.assertValidVersion(DigdagVersion.buildVersion().toString());
    }

    private void assertValidVersion(String versionString) {
        Version parsed;
        try {
            parsed = Version.parse((String)versionString);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail();
            throw ex;
        }
        Assert.assertThat((Object)parsed.toString(), (Matcher)Matchers.is((Object)versionString));
        Assert.assertTrue((boolean)parsed.equals((Object)Version.parse((String)versionString)));
        Assert.assertFalse((boolean)parsed.isOlder(Version.parse((String)versionString)));
        Assert.assertFalse((boolean)parsed.isNewer(Version.parse((String)versionString)));
        Assert.assertThat((Object)parsed.compareTo(Version.parse((String)versionString)), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testInvalidVersions() {
        this.assertInvalidVersion("", "Invalid version string: ");
        this.assertInvalidVersion("10.02", "Invalid version string: 10.02");
        this.assertInvalidVersion("00", "Invalid version string: 00");
        this.assertInvalidVersion("01", "Invalid version string: 01");
        this.assertInvalidVersion("-SNAPSHOT", "Invalid version string: -SNAPSHOT");
        this.assertInvalidVersion("0.1v", "Invalid version string: 0.1v");
        this.assertInvalidVersion("0..1", "Invalid version string: 0..1");
        this.assertInvalidVersion("1..", "Invalid version string: 1..");
        this.assertInvalidVersion("932132232132132131", "Too big version number: 932132232132132131");
    }

    private void assertInvalidVersion(String versionString, String message) {
        try {
            Version.parse((String)versionString);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.is((Object)message));
        }
    }

    @Test
    public void testOrder() {
        this.assertNewer("0.1", "0.2");
        this.assertNewer("0.1", "0.1.1");
        this.assertNewer("0.2", "0.10");
        this.assertNewer("0", "0.10");
        this.assertNewer("1.0-rc1", "1.0");
        this.assertNewer("1.0-2016T01", "1.0-2016T02");
        this.assertNewer("1.0-2016T01", "1.0-2016T01-02");
    }

    private void assertNewer(String older, String newer) {
        Version v1 = Version.parse((String)older);
        Version v2 = Version.parse((String)newer);
        Assert.assertTrue((boolean)v1.isOlder(v2));
        Assert.assertFalse((boolean)v1.isNewer(v2));
        Assert.assertThat((Object)v1.compareTo(v2), (Matcher)Matchers.is((Object)-1));
        Assert.assertFalse((boolean)v1.equals((Object)v2));
        Assert.assertFalse((boolean)v2.isOlder(v1));
        Assert.assertTrue((boolean)v2.isNewer(v1));
        Assert.assertThat((Object)v2.compareTo(v1), (Matcher)Matchers.is((Object)1));
        Assert.assertFalse((boolean)v2.equals((Object)v1));
    }

    @Test
    public void testSameOrder() {
        this.assertSameOrder("0", "0.0");
        this.assertSameOrder("1", "1.0");
        this.assertSameOrder("1.0", "1.0.0");
    }

    private void assertSameOrder(String a, String b) {
        Version v1 = Version.parse((String)a);
        Version v2 = Version.parse((String)b);
        Assert.assertFalse((boolean)v1.isOlder(v2));
        Assert.assertFalse((boolean)v1.isNewer(v2));
        Assert.assertThat((Object)v1.compareTo(v2), (Matcher)Matchers.is((Object)0));
        Assert.assertFalse((boolean)v2.isOlder(v1));
        Assert.assertFalse((boolean)v2.isNewer(v1));
        Assert.assertThat((Object)v2.compareTo(v1), (Matcher)Matchers.is((Object)0));
    }
}

