/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.CharStreams;
import io.digdag.client.DigdagClient;
import io.digdag.client.DigdagVersion;
import io.digdag.client.api.Id;
import io.digdag.client.api.ImmutableRestLogFileHandleCollection;
import io.digdag.client.api.RestDirectDownloadHandle;
import io.digdag.client.api.RestLogFileHandle;
import io.digdag.client.api.RestLogFileHandleCollection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.QueueDispatcher;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.internal.TlsUtil;
import org.bouncycastle.util.io.Streams;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DigdagClientTest {
    private MockWebServer mockWebServer;
    private DigdagClient client;
    private ObjectMapper objectMapper;

    @Before
    public void setUp() throws Exception {
        this.mockWebServer = new MockWebServer();
        HandshakeCertificates handshakeCertificates = TlsUtil.localhost();
        SSLSocketFactory socketFactory = handshakeCertificates.sslSocketFactory();
        this.mockWebServer.useHttps(socketFactory, false);
        this.mockWebServer.start();
        this.client = DigdagClient.builder().disableCertValidation(true).ssl(true).host(this.mockWebServer.getHostName()).port(this.mockWebServer.getPort()).build();
        this.objectMapper = DigdagClient.objectMapper();
    }

    @After
    public void tearDown() throws Exception {
        if (this.mockWebServer != null) {
            this.mockWebServer.shutdown();
        }
    }

    @Test
    public void getLogFileHandlesOfAttempt() throws Exception {
        ImmutableRestLogFileHandleCollection expectedLogFileHandles = RestLogFileHandleCollection.builder().addFiles(new RestLogFileHandle[]{RestLogFileHandle.builder().agentId("test-agent").fileName("test-task-1.log").fileSize(4711L).fileTime(Instant.now().truncatedTo(ChronoUnit.SECONDS)).taskName("test-task-1").build(), RestLogFileHandle.builder().agentId("test-agent").fileName("test-task-2.log").fileSize(4712L).fileTime(Instant.now().truncatedTo(ChronoUnit.SECONDS)).taskName("test-task-2").build()}).build();
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(500));
        this.mockWebServer.enqueue(new MockResponse().setBody(this.objectMapper.writeValueAsString((Object)expectedLogFileHandles)).setHeader("Content-Type", (Object)"application/json"));
        RestLogFileHandleCollection receivedLogFileHandles = this.client.getLogFileHandlesOfAttempt(Id.of((String)"17"));
        Assert.assertThat((Object)receivedLogFileHandles, (Matcher)Matchers.is((Object)expectedLogFileHandles));
        Assert.assertThat((Object)this.mockWebServer.getRequestCount(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)"/api/logs/17/files"));
        Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)"/api/logs/17/files"));
    }

    @Test
    public void getLogFileHandlesOfTask() throws Exception {
        ImmutableRestLogFileHandleCollection expectedLogFileHandles = RestLogFileHandleCollection.builder().addFiles(new RestLogFileHandle[]{RestLogFileHandle.builder().agentId("test-agent").fileName("test-task-1.log").fileSize(4711L).fileTime(Instant.now().truncatedTo(ChronoUnit.SECONDS)).taskName("test-task-1").build(), RestLogFileHandle.builder().agentId("test-agent").fileName("test-task-2.log").fileSize(4712L).fileTime(Instant.now().truncatedTo(ChronoUnit.SECONDS)).taskName("test-task-2").build()}).build();
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(500));
        this.mockWebServer.enqueue(new MockResponse().setBody(this.objectMapper.writeValueAsString((Object)expectedLogFileHandles)).setHeader("Content-Type", (Object)"application/json"));
        RestLogFileHandleCollection receivedLogFileHandles = this.client.getLogFileHandlesOfTask(Id.of((String)"17"), "test-task");
        Assert.assertThat((Object)receivedLogFileHandles, (Matcher)Matchers.is((Object)expectedLogFileHandles));
        Assert.assertThat((Object)this.mockWebServer.getRequestCount(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)"/api/logs/17/files?task=test-task"));
        Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)"/api/logs/17/files?task=test-task"));
    }

    @Test
    public void getLogFileHandlesOfTaskURLEncodedTaskName() throws Exception {
        ImmutableRestLogFileHandleCollection expectedLogFileHandles = RestLogFileHandleCollection.builder().addFiles(new RestLogFileHandle[]{RestLogFileHandle.builder().agentId("test-agent").fileName("test-task-%{}-1.log").fileSize(4711L).fileTime(Instant.now().truncatedTo(ChronoUnit.SECONDS)).taskName("test-task-%{}-1").build(), RestLogFileHandle.builder().agentId("test-agent").fileName("test-task-%{}-2.log").fileSize(4712L).fileTime(Instant.now().truncatedTo(ChronoUnit.SECONDS)).taskName("test-task-%{}-2").build()}).build();
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(500));
        this.mockWebServer.enqueue(new MockResponse().setBody(this.objectMapper.writeValueAsString((Object)expectedLogFileHandles)).setHeader("Content-Type", (Object)"application/json"));
        RestLogFileHandleCollection receivedLogFileHandles = this.client.getLogFileHandlesOfTask(Id.of((String)"17"), "test-task-%{}");
        Assert.assertThat((Object)receivedLogFileHandles, (Matcher)Matchers.is((Object)expectedLogFileHandles));
        Assert.assertThat((Object)this.mockWebServer.getRequestCount(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)"/api/logs/17/files?task=test-task-%25%7B%7D"));
        Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)"/api/logs/17/files?task=test-task-%25%7B%7D"));
    }

    @Test
    public void getLogFileDirect() throws Exception {
        Id attemptId = Id.of((String)"17");
        String logFileContents = "foo\nbar";
        String logFilePath = "/logs/test-task-1.log";
        String logFileUrl = "https://" + this.mockWebServer.getHostName() + ":" + this.mockWebServer.getPort() + logFilePath;
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(500));
        this.mockWebServer.enqueue(new MockResponse().setBody(logFileContents).setHeader("Content-Type", (Object)"text/plain"));
        InputStream logFileStream = this.client.getLogFile(attemptId, (RestLogFileHandle)RestLogFileHandle.builder().direct(RestDirectDownloadHandle.of((String)logFileUrl)).agentId("test-agent").fileName("test-task-1.log").fileSize(4711L).fileTime(Instant.now().truncatedTo(ChronoUnit.SECONDS)).taskName("test-task-1").build());
        String receivedLogFileContents = CharStreams.toString((Readable)new InputStreamReader(logFileStream));
        Assert.assertThat((Object)receivedLogFileContents, (Matcher)Matchers.is((Object)logFileContents));
        Assert.assertThat((Object)this.mockWebServer.getRequestCount(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)logFilePath));
        Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)logFilePath));
    }

    @Test
    public void getLogFile() throws Exception {
        int attemptId = 17;
        String logFileContents = "foo\nbar";
        String logFileName = "test-task-1.log";
        String logFilePath = "/api/logs/" + attemptId + "/files/" + logFileName;
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(500));
        this.mockWebServer.enqueue(new MockResponse().setBody(logFileContents).setHeader("Content-Type", (Object)"text/plain"));
        InputStream logFileStream = this.client.getLogFile(Id.of((String)"17"), (RestLogFileHandle)RestLogFileHandle.builder().agentId("test-agent").fileName(logFileName).fileSize(4711L).fileTime(Instant.now().truncatedTo(ChronoUnit.SECONDS)).taskName("test-task-1").build());
        String receivedLogFileContents = CharStreams.toString((Readable)new InputStreamReader(logFileStream));
        Assert.assertThat((Object)receivedLogFileContents, (Matcher)Matchers.is((Object)logFileContents));
        Assert.assertThat((Object)this.mockWebServer.getRequestCount(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)logFilePath));
        Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)logFilePath));
    }

    @Test
    public void getLogFileFailsAfter10Attempts() throws Exception {
        QueueDispatcher dispatcher = new QueueDispatcher();
        dispatcher.setFailFast(new MockResponse().setResponseCode(500));
        this.mockWebServer.setDispatcher((Dispatcher)dispatcher);
        try {
            this.client.getLogFile(Id.of((String)"17"), (RestLogFileHandle)RestLogFileHandle.builder().agentId("test-agent").fileName("test-task-1.log").fileSize(4711L).fileTime(Instant.now().truncatedTo(ChronoUnit.SECONDS)).taskName("test-task-1").build());
            Assert.fail();
        }
        catch (InternalServerErrorException internalServerErrorException) {
            // empty catch block
        }
        Assert.assertThat((Object)this.mockWebServer.getRequestCount(), (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testUserAgent() throws Exception {
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody("{\"version\":\"1.2.3\"}"));
        this.client.getVersion();
        Assert.assertThat((Object)this.mockWebServer.getRequestCount(), (Matcher)Matchers.is((Object)1));
        RecordedRequest request = this.mockWebServer.takeRequest();
        Assert.assertThat((Object)request.getHeader("User-Agent"), (Matcher)Matchers.is((Object)("DigdagClient/" + DigdagVersion.buildVersion())));
    }

    @Test
    public void testAcceptEncoding() throws InterruptedException {
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody("{\"version\":\"1.2.3\"}"));
        this.client.getVersion();
        RecordedRequest request = this.mockWebServer.takeRequest();
        Assert.assertThat((Object)request.getHeader("Accept-Encoding"), (Matcher)Matchers.is((Object)"gzip, deflate"));
    }

    @Test
    public void getProjectArchiveWithRedirect() throws IOException, InterruptedException {
        String redirectUrl = String.format("https://%s:%d/redirect/pathname", this.mockWebServer.getHostName(), this.mockWebServer.getPort());
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(303).setHeader("Location", (Object)redirectUrl));
        this.mockWebServer.enqueue(new MockResponse().setResponseCode(200).setBody("foobar"));
        InputStream archive = this.client.getProjectArchive(Id.of((String)"42"), "12345678-abcdef");
        Assert.assertArrayEquals((byte[])"foobar".getBytes(StandardCharsets.UTF_8), (byte[])Streams.readAll((InputStream)archive));
        Assert.assertThat((Object)this.mockWebServer.getRequestCount(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)"/api/projects/42/archive?revision=12345678-abcdef"));
        Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)"/redirect/pathname"));
    }

    @Test
    public void getProjectArchiveWithRedirect10Times() throws IOException, InterruptedException {
        String redirectUrl = String.format("https://%s:%d/redirect/pathname", this.mockWebServer.getHostName(), this.mockWebServer.getPort());
        for (int i = 0; i < 10; ++i) {
            this.mockWebServer.enqueue(new MockResponse().setResponseCode(303).setHeader("Location", (Object)redirectUrl));
        }
        try {
            this.client.getProjectArchive(Id.of((String)"42"), "12345678-abcdef");
            Assert.assertTrue((boolean)false);
        }
        catch (WebApplicationException e) {
            Assert.assertThat((Object)this.mockWebServer.getRequestCount(), (Matcher)Matchers.is((Object)10));
            Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)"/api/projects/42/archive?revision=12345678-abcdef"));
            for (int i = 0; i < 9; ++i) {
                Assert.assertThat((Object)this.mockWebServer.takeRequest().getPath(), (Matcher)Matchers.is((Object)"/redirect/pathname"));
            }
        }
    }
}

