/*
 *
 * Copyright © 2018 Webvalto Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.devbench.uibuilder.security.core.templateparsers.role;

import io.devbench.uibuilder.api.singleton.SingletonManager;
import io.devbench.uibuilder.security.api.SecurityService;
import io.devbench.uibuilder.security.core.templateparsers.TagNameMarkedTemplateParser;
import io.devbench.uibuilder.security.core.templateparsers.TagReplaceTemplateParser;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Element;

public class HasRoleTemplateParser implements TagNameMarkedTemplateParser, TagReplaceTemplateParser {
    @Getter
    private final String tagName = "has-role";
    private final String attribute = "name";

    @Override
    public boolean test(Element element) {
        final String role = element.attr(attribute);
        return StringUtils.isNotBlank(role) && SingletonManager.getInstanceOf(SecurityService.class).hasRole(role);
    }
}
