/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.security.core.flow.xml;

import io.devbench.uibuilder.api.singleton.SingletonManager;
import io.devbench.uibuilder.core.flow.parsed.ParsedFlowElement;
import io.devbench.uibuilder.core.flow.xml.FlowElement;
import io.devbench.uibuilder.core.flow.xml.FlowTargetInherited;
import io.devbench.uibuilder.core.flow.xml.HasSubFlow;
import io.devbench.uibuilder.security.api.SecurityService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="hasPermission")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class HasPermissionFlowElement
extends FlowElement
implements HasSubFlow,
FlowTargetInherited {
    @XmlAttribute
    private String permission;
    @XmlAttribute
    private String fallbackId;
    @XmlElementRef
    private List<FlowElement> subFlows = new ArrayList<FlowElement>();

    private Optional<String> getAlternativeNavigationId() {
        boolean permitted = Stream.of(this.permission.split(",")).anyMatch(arg_0 -> ((SecurityService)((SecurityService)SingletonManager.getInstanceOf(SecurityService.class))).isPermitted(arg_0));
        if (permitted) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.fallbackId);
    }

    public ParsedFlowElement convertToParsedElement() {
        return new ParsedFlowElement(UUID.randomUUID().toString(), this::getAlternativeNavigationId);
    }

    public String getPermission() {
        return this.permission;
    }

    public String getFallbackId() {
        return this.fallbackId;
    }

    public List<FlowElement> getSubFlows() {
        return this.subFlows;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public void setFallbackId(String fallbackId) {
        this.fallbackId = fallbackId;
    }

    public void setSubFlows(List<FlowElement> subFlows) {
        this.subFlows = subFlows;
    }

    public String toString() {
        return "HasPermissionFlowElement(permission=" + this.getPermission() + ", fallbackId=" + this.getFallbackId() + ", subFlows=" + this.getSubFlows() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasPermissionFlowElement)) {
            return false;
        }
        HasPermissionFlowElement other = (HasPermissionFlowElement)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$permission = this.getPermission();
        String other$permission = other.getPermission();
        if (this$permission == null ? other$permission != null : !this$permission.equals(other$permission)) {
            return false;
        }
        String this$fallbackId = this.getFallbackId();
        String other$fallbackId = other.getFallbackId();
        if (this$fallbackId == null ? other$fallbackId != null : !this$fallbackId.equals(other$fallbackId)) {
            return false;
        }
        List<FlowElement> this$subFlows = this.getSubFlows();
        List<FlowElement> other$subFlows = other.getSubFlows();
        return !(this$subFlows == null ? other$subFlows != null : !((Object)this$subFlows).equals(other$subFlows));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HasPermissionFlowElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $permission = this.getPermission();
        result = result * 59 + ($permission == null ? 43 : $permission.hashCode());
        String $fallbackId = this.getFallbackId();
        result = result * 59 + ($fallbackId == null ? 43 : $fallbackId.hashCode());
        List<FlowElement> $subFlows = this.getSubFlows();
        result = result * 59 + ($subFlows == null ? 43 : ((Object)$subFlows).hashCode());
        return result;
    }

    public HasPermissionFlowElement() {
    }

    public HasPermissionFlowElement(String permission, String fallbackId, List<FlowElement> subFlows) {
        this.permission = permission;
        this.fallbackId = fallbackId;
        this.subFlows = subFlows;
    }
}

