/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.security.core.templateparsers;

import io.devbench.uibuilder.api.singleton.SingletonManager;
import io.devbench.uibuilder.security.api.SecurityService;
import io.devbench.uibuilder.security.core.templateparsers.TagNameMarkedTemplateParser;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Element;

public class PrincipalTemplateParser
implements TagNameMarkedTemplateParser {
    private final String tagName = "principal";
    private final String attribute = "property";

    public Element processTemplate(Element element) {
        String methodName = element.attr("property");
        Element div = new Element("div");
        Object principal = ((SecurityService)SingletonManager.getInstanceOf(SecurityService.class)).getPrincipal();
        if (null != principal) {
            div.text(this.getValue(principal, methodName));
        }
        return div;
    }

    private String principalMethodName(String role) {
        return "get" + StringUtils.capitalize((String)role);
    }

    private String getValue(Object principal, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return principal.toString();
        }
        try {
            Class<?> principalClass = principal.getClass();
            Method method = principalClass.getMethod(this.principalMethodName(name), new Class[0]);
            return method.invoke(principal, new Object[0]).toString();
        }
        catch (Throwable e) {
            return principal.toString();
        }
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }
}

