/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.security.shiro;

import io.devbench.uibuilder.api.singleton.SingletonManager;
import io.devbench.uibuilder.security.api.SecurityService;
import io.devbench.uibuilder.spring.security.shiro.ShiroSecurityService;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroFilterConfiguration {
    @Bean
    public SecurityService securityService() {
        ShiroSecurityService securityService = new ShiroSecurityService();
        SingletonManager.registerSingleton(SecurityService.class, (Object)securityService);
        return securityService;
    }

    @Bean
    public WebSecurityManager webSecurityManager(Realm realm) {
        return new DefaultWebSecurityManager(realm);
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilterFactoryBean(WebSecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager((SecurityManager)securityManager);
        return shiroFilterFactoryBean;
    }
}

