/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.security.login;

import io.devbench.uibuilder.spring.security.login.AfterLoginFunction;
import io.devbench.uibuilder.spring.security.login.LoginService;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultLoginServiceImpl
implements LoginService {
    private static final Logger log = LoggerFactory.getLogger(DefaultLoginServiceImpl.class);

    @Override
    public void login(String username, String password, AfterLoginFunction afterLogin) {
        Subject subject = this.getSubject();
        try {
            subject.login(this.createTokenWithUsernameAndPassword(username, password));
            afterLogin.isSucceedLogin(true);
        }
        catch (AuthenticationException e) {
            log.error("Login panel authentication failed", (Throwable)e);
            afterLogin.isSucceedLogin(false);
        }
    }
}

