/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.springboot;

import com.vaadin.flow.spring.RootMappedCondition;
import com.vaadin.flow.spring.SpringServlet;
import com.vaadin.flow.spring.VaadinConfigurationProperties;
import io.devbench.uibuilder.spring.UIBuilderServlet;
import io.devbench.uibuilder.spring.configuration.staticcontent.StaticContentDescription;
import java.util.HashMap;
import javax.servlet.Servlet;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;

@Configuration
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class})
@ConditionalOnClass(value={ServletContextInitializer.class})
@EnableConfigurationProperties(value={VaadinConfigurationProperties.class})
public class UIBuilderSpringBootAutoConfiguration {
    static final String VAADIN_SERVLET_MAPPING = "/vaadinServlet/*";
    @Autowired
    private WebApplicationContext context;
    @Autowired
    private VaadinConfigurationProperties configurationProperties;
    @Autowired(required=false)
    @Nullable
    private StaticContentDescription staticContentDescription;

    @Bean
    @Primary
    public ServletRegistrationBean<SpringServlet> uibuilderSpringBootServlet() {
        String mapping = this.configurationProperties.getUrlMapping();
        HashMap<String, String> initParameters = new HashMap<String, String>();
        boolean rootMapping = RootMappedCondition.isRootMapping((String)mapping);
        if (rootMapping) {
            mapping = VAADIN_SERVLET_MAPPING;
            initParameters.put("pushURL", UIBuilderSpringBootAutoConfiguration.makeContextRelative(mapping.replace("*", "")));
        }
        UIBuilderServlet uiBuilderServlet = new UIBuilderServlet((ApplicationContext)this.context, this.staticContentDescription);
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)uiBuilderServlet, new String[]{mapping});
        registration.setInitParameters(initParameters);
        registration.setOrder(1);
        registration.setAsyncSupported(this.configurationProperties.isAsyncSupported());
        registration.setName(ClassUtils.getShortNameAsProperty(SpringServlet.class));
        return registration;
    }

    private static String makeContextRelative(String url) {
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        return "context://" + url;
    }
}

