/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.data;

import io.devbench.uibuilder.api.parse.BindingContext;
import io.devbench.uibuilder.data.api.annotations.TargetDataSource;
import io.devbench.uibuilder.data.common.datasource.CommonDataSource;
import io.devbench.uibuilder.data.common.datasource.CommonDataSourceProvider;
import io.devbench.uibuilder.data.common.datasource.CommonDataSourceSelector;
import io.devbench.uibuilder.spring.data.SpringDataSourceProvider;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.PagingAndSortingRepository;

public abstract class SpringCommonDataSourceProvider<DATA_SOURCE extends CommonDataSource<?, ?, ?, ?>, REPOSITORY_TYPE extends PagingAndSortingRepository>
extends SpringDataSourceProvider<DATA_SOURCE, CommonDataSourceSelector>
implements CommonDataSourceProvider<DATA_SOURCE> {
    protected final ApplicationContext applicationContext;
    protected Map<String, BindingContext> registeredBindingContexts;
    protected Map<String, Pair<TargetDataSource, Class<? extends REPOSITORY_TYPE>>> dataSourceRepositories;
    protected Map<String, String> idToDataSourceName;

    public SpringCommonDataSourceProvider(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.registeredBindingContexts = new HashMap<String, BindingContext>();
        this.idToDataSourceName = new HashMap<String, String>();
    }

    public final void registerBindingContextForDataSource(BindingContext bindingContext, @Nullable CommonDataSourceSelector dataSourceSelector) {
        this.idToDataSourceName.put(bindingContext.getDataSourceId(), bindingContext.getDataSourceName());
        if (!bindingContext.getBindings().isEmpty()) {
            String bindingsKey = this.createBindingsKey(bindingContext.getDataSourceId(), this.getOptionalDefaultQueryName(dataSourceSelector));
            this.registeredBindingContexts.put(bindingsKey, bindingContext);
        }
    }

    @Nullable
    public final BindingContext getBindingContextForName(String dataSourceName, @Nullable CommonDataSourceSelector dataSourceSelector) {
        return this.registeredBindingContexts.get(this.createBindingsKey(dataSourceName, this.getOptionalDefaultQueryName(dataSourceSelector)));
    }

    protected final Optional<Pair<TargetDataSource, Class<? extends REPOSITORY_TYPE>>> findDataSourceNameById(String dataSourceId) {
        return Optional.ofNullable(this.getDataSourceRepositories().get(this.idToDataSourceName.get(dataSourceId)));
    }

    public Optional<Class<?>> tryToFindEntityClassByRepositoryClass(Class<? extends PagingAndSortingRepository<?, ?>> repoClass) {
        return Arrays.stream(repoClass.getGenericInterfaces()).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).map(type -> type.getActualTypeArguments()[0]).filter(Class.class::isInstance).map(entityType -> (Class)entityType).findAny();
    }

    public Map<String, Pair<TargetDataSource, Class<? extends REPOSITORY_TYPE>>> getDataSourceRepositories() {
        return this.dataSourceRepositories;
    }
}

