/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.data;

import io.devbench.uibuilder.api.parse.BindingContext;
import io.devbench.uibuilder.data.collectionds.CollectionDataSource;
import io.devbench.uibuilder.data.collectionds.interceptors.ItemDataSourceBindingContext;
import io.devbench.uibuilder.data.common.datasource.CommonDataSourceProvider;
import io.devbench.uibuilder.data.common.datasource.CommonDataSourceSelector;
import io.devbench.uibuilder.spring.data.SpringDataSourceProvider;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="uibuilderBasicSpringDataSourceProvider")
public class BasicSpringDataSourceProvider<T>
extends SpringDataSourceProvider<CollectionDataSource<T>, CommonDataSourceSelector>
implements CommonDataSourceProvider<CollectionDataSource<T>> {
    public static final String BASIC_SPRING_DATA_SOURCE_PROVIDER_BEAN_NAME = "uibuilderBasicSpringDataSourceProvider";
    protected final ApplicationContext applicationContext;
    protected Map<String, BindingContext> registeredBindingContexts;
    protected Map<String, String> idToDataSourceName;

    public BasicSpringDataSourceProvider(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.registeredBindingContexts = new HashMap<String, BindingContext>();
        this.idToDataSourceName = new HashMap<String, String>();
    }

    public CollectionDataSource<T> createNewDataSource(String dataSourceId, @Nullable String optionalDefaultQueryName) {
        BindingContext bindingContext = this.registeredBindingContexts.get(this.createBindingsKey(dataSourceId, optionalDefaultQueryName));
        ItemDataSourceBindingContext itemDataSourceBindingContext = (ItemDataSourceBindingContext)bindingContext;
        return new CollectionDataSource(itemDataSourceBindingContext, itemDataSourceBindingContext.getKeyPaths(), Collections.emptyList());
    }

    @Override
    public Set<Class<? extends Annotation>> getInterestedAnnotationTypes() {
        return Collections.emptySet();
    }

    @Override
    protected void lateInit() {
    }

    public void registerBindingContextForDataSource(BindingContext bindingContext, @Nullable CommonDataSourceSelector dataSourceSelector) {
        this.idToDataSourceName.put(bindingContext.getDataSourceId(), bindingContext.getDataSourceName());
        if (!bindingContext.getBindings().isEmpty()) {
            String bindingsKey = this.createBindingsKey(bindingContext.getDataSourceId(), this.getOptionalDefaultQueryName(dataSourceSelector));
            this.registeredBindingContexts.put(bindingsKey, bindingContext);
        }
    }

    @Nullable
    public final BindingContext getBindingContextForName(String dataSourceName, @Nullable CommonDataSourceSelector dataSourceSelector) {
        return this.registeredBindingContexts.get(this.createBindingsKey(dataSourceName, this.getOptionalDefaultQueryName(dataSourceSelector)));
    }
}

