/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.crud;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.spring.annotation.UIScope;
import io.devbench.uibuilder.annotations.ControllerBean;
import io.devbench.uibuilder.api.controllerbean.uieventhandler.Item;
import io.devbench.uibuilder.api.controllerbean.uieventhandler.Source;
import io.devbench.uibuilder.api.controllerbean.uieventhandler.UIEventHandler;
import io.devbench.uibuilder.api.controllerbean.uieventhandler.Value;
import io.devbench.uibuilder.api.crud.CanCreate;
import io.devbench.uibuilder.api.crud.GenericCrudControllerBean;
import io.devbench.uibuilder.api.crud.Refreshable;
import io.devbench.uibuilder.spring.crud.GenericCrudData;
import io.devbench.uibuilder.spring.data.SpringCommonDataSourceProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.PagingAndSortingRepository;

@UIScope
@ControllerBean(value="builtInGenericCrudPanelControllerBean")
public class SpringGenericCrudControllerBean<TYPE>
implements GenericCrudControllerBean<TYPE> {
    private static final Logger log = LoggerFactory.getLogger(SpringGenericCrudControllerBean.class);
    private final Map<String, GenericCrudData<?>> genericCrudDataMdcIdMap;
    private final SpringCommonDataSourceProvider commonDataSourceProvider;
    private final ApplicationContext applicationContext;
    private Consumer<String> inlineItemSaveCrudPanelIdConsumer;

    public SpringGenericCrudControllerBean(SpringCommonDataSourceProvider commonDataSourceProvider, ApplicationContext applicationContext) {
        this.commonDataSourceProvider = commonDataSourceProvider;
        this.applicationContext = applicationContext;
        this.genericCrudDataMdcIdMap = new HashMap();
    }

    private void withMdc(Refreshable refreshable, Consumer<GenericCrudData<TYPE>> crudDataConsumer) {
        if (refreshable instanceof Component) {
            ((Component)refreshable).getId().ifPresent(mdcId -> {
                GenericCrudData<?> crudData = this.genericCrudDataMdcIdMap.get(mdcId);
                if (crudData != null) {
                    crudDataConsumer.accept(crudData);
                    refreshable.refresh();
                } else {
                    log.error("Crud data is unavailable for MDC ID: {}", mdcId);
                }
            });
        }
    }

    private void withRepository(Refreshable refreshable, Consumer<PagingAndSortingRepository<TYPE, ?>> repositoryConsumer) {
        this.withMdc(refreshable, crudData -> repositoryConsumer.accept(crudData.getRepository()));
    }

    private Optional<GenericCrudData<TYPE>> createCrudData(@NotNull String datasourceName) {
        Pair datasourceRepoPair = this.commonDataSourceProvider.getDataSourceRepositories().get(datasourceName);
        if (datasourceRepoPair != null) {
            Class repositoryClass = (Class)datasourceRepoPair.getValue();
            ObjectProvider repositoryProvider = this.applicationContext.getBeanProvider(repositoryClass);
            PagingAndSortingRepository repository = (PagingAndSortingRepository)repositoryProvider.getIfAvailable();
            if (repository != null) {
                Optional<Class<?>> itemClass = this.commonDataSourceProvider.tryToFindEntityClassByRepositoryClass(repositoryClass);
                if (itemClass.isPresent()) {
                    return Optional.of(new GenericCrudData(itemClass.get(), repository));
                }
                log.error("Could not find repository item type for datasource: {}", (Object)datasourceName);
            } else {
                log.error("Could not get repository bean for class: {}", (Object)repositoryClass);
            }
        }
        return Optional.empty();
    }

    public void registerGenericCrudData(@NotNull String mdcId, @NotNull String datasourceName) {
        this.createCrudData(datasourceName).ifPresent(crudData -> this.genericCrudDataMdcIdMap.put(mdcId, (GenericCrudData<?>)crudData));
    }

    public void registerNestedInlineItemSaveHandler(@NotNull Consumer<String> inlineItemSaveCrudPanelIdConsumer) {
        this.inlineItemSaveCrudPanelIdConsumer = inlineItemSaveCrudPanelIdConsumer;
    }

    @UIEventHandler(value="onSave")
    public void onSave(@Item TYPE subject, @Source Refreshable refreshable) {
        this.withRepository(refreshable, repository -> repository.save(subject));
    }

    @UIEventHandler(value="onDelete")
    public void onDelete(@Item TYPE subject, @Source Refreshable refreshable) {
        this.withRepository(refreshable, repository -> repository.delete(subject));
    }

    @UIEventHandler(value="onRefresh")
    public void refresh(@Source Refreshable refreshable) {
        if (refreshable != null) {
            refreshable.refresh();
        }
    }

    @UIEventHandler(value="onCreate")
    public void onCreate(@Source Refreshable refreshable) {
        this.withMdc(refreshable, crudData -> {
            try {
                Constructor constructor = crudData.getItemClass().getConstructor(new Class[0]);
                Object item = constructor.newInstance(new Object[0]);
                if (refreshable instanceof CanCreate) {
                    CanCreate canCreate = (CanCreate)refreshable;
                    canCreate.createItem(item);
                } else {
                    log.error("Component cannot create item: {}", (Object)refreshable);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Could not created generic type instance", (Throwable)e);
            }
        });
    }

    @UIEventHandler(value="handleNestedInlineItemSave")
    public void handleNestedInlineItemSave(@Value(value="detail.crudPanel") @Nullable String memberCrudPanelId) {
        if (this.inlineItemSaveCrudPanelIdConsumer != null) {
            this.inlineItemSaveCrudPanelIdConsumer.accept(memberCrudPanelId);
        }
    }

    Map<String, GenericCrudData<?>> getGenericCrudDataMdcIdMap() {
        return this.genericCrudDataMdcIdMap;
    }
}

