/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.singleton;

import io.devbench.uibuilder.api.singleton.ContextAwareSingletonHolder;
import io.devbench.uibuilder.api.singleton.SingletonProvider;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;

final class SpringSingletonManagerContextHolder {
    private Collection<SingletonProvider> singletonProviders;
    private Collection<ContextAwareSingletonHolder> contextAwareSingletonHolders;

    SpringSingletonManagerContextHolder(@NotNull ApplicationContext applicationContext) {
        this.singletonProviders = applicationContext.getBeansOfType(SingletonProvider.class).values();
        this.contextAwareSingletonHolders = applicationContext.getBeansOfType(ContextAwareSingletonHolder.class).values();
    }

    Collection<SingletonProvider> getSingletonProviders() {
        return Collections.unmodifiableCollection(this.singletonProviders);
    }

    Collection<ContextAwareSingletonHolder> getContextAwareSingletonHolders() {
        return Collections.unmodifiableCollection(this.contextAwareSingletonHolders);
    }
}

