/*
 * Decompiled with CFR 0.152.
 */
package io.devbench.uibuilder.spring.crud;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.spring.annotation.UIScope;
import io.devbench.uibuilder.annotations.ControllerBean;
import io.devbench.uibuilder.api.components.HasRawElementComponent;
import io.devbench.uibuilder.api.components.masterconnector.UIBuilderMasterConnector;
import io.devbench.uibuilder.api.controllerbean.uieventhandler.Item;
import io.devbench.uibuilder.api.controllerbean.uieventhandler.Source;
import io.devbench.uibuilder.api.controllerbean.uieventhandler.UIEventHandler;
import io.devbench.uibuilder.api.crud.CanCreate;
import io.devbench.uibuilder.api.crud.GenericItemCrudControllerBean;
import io.devbench.uibuilder.api.crud.MasterConnectorProvider;
import io.devbench.uibuilder.api.crud.Refreshable;
import io.devbench.uibuilder.core.parse.elementwalker.ElementWalker;
import io.devbench.uibuilder.core.utils.reflection.ClassMetadata;
import io.devbench.uibuilder.core.utils.reflection.PropertyMetadata;
import io.devbench.uibuilder.spring.crud.exception.GenericItemCrudControllerException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.persistence.OneToMany;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UIScope
@ControllerBean(value="builtInGenericItemCrudPanelControllerBean")
public class SpringGenericItemCrudControllerBean<TYPE, J>
implements GenericItemCrudControllerBean<TYPE, J> {
    private static final Logger log = LoggerFactory.getLogger(SpringGenericItemCrudControllerBean.class);
    public static final String ITEM_BIND = "item-bind";
    public static final String ITEM_BIND_ITEMS_PREFIX = "items:";
    public static final String ITEM_DATA_SOURCE = "item-data-source";
    private final Map<String, Supplier<?>> joinItemSuppliers = new HashMap();

    public void registerJoinItemSupplier(@NotNull String mdcId, @Nullable Supplier<?> joinItemSupplier) {
        this.joinItemSuppliers.put(mdcId, joinItemSupplier);
    }

    @UIEventHandler(value="onRefresh")
    public void refresh(@Source Refreshable refreshable) {
        if (refreshable != null) {
            refreshable.refresh();
        }
    }

    @UIEventHandler(value="onSave")
    public void onSave(@Item TYPE subject, @Source Refreshable refreshable) {
        if (this.asItemCreateProvider(refreshable).isSelectedItemCreated()) {
            this.asMasterConnectorProvider(refreshable).getMasterConnector().addItem(subject);
        }
        refreshable.refresh();
    }

    @UIEventHandler(value="onDelete")
    public void onDelete(@Item TYPE subject, @Source Refreshable refreshable) {
    }

    @UIEventHandler(value="onCreate")
    public void onCreate(@Source Refreshable refreshable) {
        CanCreate<TYPE> itemCreateProvider = this.asItemCreateProvider(refreshable);
        UIBuilderMasterConnector masterConnector = this.asMasterConnectorProvider(refreshable).getMasterConnector();
        Component masterComponent = masterConnector.getMasterComponent();
        if (masterComponent instanceof HasRawElementComponent) {
            Element masterElement = ((HasRawElementComponent)masterComponent).getRawElement();
            this.findReferencedParentCollectionPropertyName(masterElement).ifPresent(parentItemCollectionPropertyName -> this.findParentMdcId(masterElement).ifPresent(parentMdcId -> this.handleOneToManyRelation(itemCreateProvider, (String)parentItemCollectionPropertyName, (String)parentMdcId)));
        }
    }

    private Optional<String> findParentMdcId(Element currentMasterElement) {
        AtomicReference foundParentMdcId = new AtomicReference();
        currentMasterElement.parents().stream().filter(element -> "detail-panel".equals(element.normalName())).findFirst().map(Element::id).ifPresent(detailPanelId -> {
            Element rootElement = (Element)currentMasterElement.root();
            ElementWalker.of((Element)rootElement).withProcessor(element -> {
                if ("master-detail-controller".equals(element.normalName()) && element.attr("detail").trim().equals(detailPanelId)) {
                    foundParentMdcId.set(element.id());
                }
                return new Elements(new Element[]{element});
            }).walk();
        });
        return Optional.ofNullable((String)foundParentMdcId.get());
    }

    private MasterConnectorProvider<TYPE> asMasterConnectorProvider(Refreshable refreshable) {
        if (refreshable instanceof MasterConnectorProvider) {
            return (MasterConnectorProvider)refreshable;
        }
        throw new GenericItemCrudControllerException("Source is not a master connector provider");
    }

    private CanCreate<TYPE> asItemCreateProvider(Refreshable refreshable) {
        if (refreshable instanceof CanCreate) {
            return (CanCreate)refreshable;
        }
        throw new GenericItemCrudControllerException("Source is not an item create provider");
    }

    private Optional<String> findReferencedParentCollectionPropertyName(Element masterElement) {
        String masterComponentItemBind = masterElement.attr(ITEM_BIND).trim();
        if (masterComponentItemBind.startsWith(ITEM_BIND_ITEMS_PREFIX)) {
            return Optional.of(masterComponentItemBind.substring(ITEM_BIND_ITEMS_PREFIX.length()));
        }
        return masterElement.children().stream().filter(element -> ITEM_DATA_SOURCE.equals(element.normalName())).filter(element -> element.hasAttr(ITEM_BIND)).filter(element -> element.attr(ITEM_BIND).trim().startsWith(ITEM_BIND_ITEMS_PREFIX)).map(element -> element.attr(ITEM_BIND).trim().substring(ITEM_BIND_ITEMS_PREFIX.length())).findFirst();
    }

    private void handleOneToManyRelation(CanCreate<TYPE> itemCreateProvider, String parentItemCollectionPropertyName, String parentMdcId) {
        Supplier<?> parentSelectedItemSupplier = this.joinItemSuppliers.get(parentMdcId);
        if (parentSelectedItemSupplier != null) {
            Object parentSelectedItem = parentSelectedItemSupplier.get();
            ClassMetadata parentSelectedItemClassMetadata = ClassMetadata.ofValue(parentSelectedItem);
            parentSelectedItemClassMetadata.getProperties().stream().filter(propertyMetadata -> parentItemCollectionPropertyName.equals(propertyMetadata.getName())).filter(propertyMetadata -> Collection.class.isAssignableFrom(propertyMetadata.getType())).filter(propertyMetadata -> propertyMetadata.getParameterizedType().getActualTypeArguments().length == 1).findFirst().ifPresent(propertyMetadata -> this.handleOneToManyRelationPropertyValues(itemCreateProvider, parentSelectedItem, (ClassMetadata<?>)parentSelectedItemClassMetadata, (PropertyMetadata<?>)propertyMetadata));
        }
    }

    private void handleOneToManyRelationPropertyValues(CanCreate<TYPE> itemCreateProvider, Object parentSelectedItem, ClassMetadata<?> parentSelectedItemClassMetadata, PropertyMetadata<?> propertyMetadata) {
        String newItemJoinPropertyName;
        Type itemType = propertyMetadata.getParameterizedType().getActualTypeArguments()[0];
        if (propertyMetadata.isAnnotationPresent(OneToMany.class) && !(newItemJoinPropertyName = ((OneToMany)propertyMetadata.getAnnotation(OneToMany.class)).mappedBy()).isEmpty()) {
            TYPE newItem = this.instantiateNewItem(itemType);
            PropertyMetadata newItemJoinPropertyMetadata = ClassMetadata.ofValue(newItem).getProperties().stream().filter(newItemPropertyMetadata -> newItemPropertyMetadata.getName().equals(newItemJoinPropertyName)).filter(newItemPropertyMetadata -> newItemPropertyMetadata.getType().isAssignableFrom(parentSelectedItemClassMetadata.getTargetClass())).findFirst().orElseThrow(() -> new GenericItemCrudControllerException("Could not find join field in class " + itemType.getTypeName() + " by property name: " + newItemJoinPropertyName));
            newItemJoinPropertyMetadata.setValue(parentSelectedItem);
            itemCreateProvider.createItem(newItem);
        }
    }

    private TYPE instantiateNewItem(Type itemType) {
        try {
            Object newItem = ((Class)itemType).getConstructor(new Class[0]).newInstance(new Object[0]);
            return (TYPE)newItem;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new GenericItemCrudControllerException("Could not instantiate new item from type " + itemType.getTypeName(), e);
        }
    }
}

